/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.manifestview;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.gui.AttributeEditor;
import uk.ac.reload.moonunit.schema.SchemaAttribute;

public class ManifestAttributeEditor
extends AttributeEditor {
    protected TableCellEditor createTableCellEditor() {
        return new ManifestAttributeCellEditor();
    }

    protected AbstractTableModel createTableModel() {
        return new ManifestAttributeTableModel();
    }

    class ID_Mapping {
        ContentPackage _cp;
        Element _element;

        ID_Mapping(ContentPackage cp, Element element) {
            this._cp = cp;
            this._element = element;
        }

        public String getIdentifier() {
            if (this._element == null) {
                return "";
            }
            return this._element.getAttributeValue("identifier");
        }

        public String toString() {
            if (this._element == null) {
                return "(none)";
            }
            return this._cp.getElementDisplayName(this._element);
        }
    }

    class ManifestAttributeCellEditor
    extends AttributeEditor.AttributeCellEditor {
        public ManifestAttributeCellEditor() {
            super(ManifestAttributeEditor.this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String attName = null;
            SchemaAttribute schemaAtt = ManifestAttributeEditor.this.getSchemaAttribute(row);
            if (schemaAtt != null) {
                attName = schemaAtt.getName();
            } else {
                Attribute att = ManifestAttributeEditor.this.getAttribute(row);
                if (att != null) {
                    attName = att.getName();
                }
            }
            if (attName != null) {
                ContentPackage cp = (ContentPackage)ManifestAttributeEditor.this.getElementBinding().getSchemaDocument();
                Element element = ManifestAttributeEditor.this.getElementBinding().getElement();
                String elementName = element.getName();
                Element[] elements = null;
                if (elementName.equals("item") || elementName.equals("dependency")) {
                    if (attName.equals("identifierref")) {
                        elements = cp.getReferencedElementsAllowed(element);
                    }
                } else if (elementName.equals("organizations") && attName.equals("default")) {
                    elements = cp.getOrganizationsAllowed(element);
                }
                if (elements != null && elements.length > 0) {
                    Object[] id_mappings = new ID_Mapping[elements.length + 1];
                    id_mappings[0] = new ID_Mapping(cp, null);
                    String id_ref = element.getAttributeValue(attName);
                    Object selected = null;
                    for (int i = 1; i < id_mappings.length; ++i) {
                        id_mappings[i] = new ID_Mapping(cp, elements[i - 1]);
                        if (id_ref == null || ((ID_Mapping)id_mappings[i]).getIdentifier() == null || !id_ref.equals(((ID_Mapping)id_mappings[i]).getIdentifier())) continue;
                        selected = id_mappings[i];
                    }
                    this.editor = this.comboEditor;
                    this.comboBox.setItems(id_mappings);
                    this.comboBox.setEditable(false);
                    this.comboBox.setSelectedItem(selected);
                    return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class ManifestAttributeTableModel
    extends AttributeEditor.AttributeTableModel {
        ManifestAttributeTableModel() {
            super(ManifestAttributeEditor.this);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue instanceof ID_Mapping) {
                aValue = ((ID_Mapping)aValue).getIdentifier();
            }
            super.setValueAt(aValue, rowIndex, columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    Attribute att = ManifestAttributeEditor.this.getAttribute(rowIndex);
                    if (att != null) {
                        ContentPackage cp = (ContentPackage)ManifestAttributeEditor.this.getElementBinding().getSchemaDocument();
                        Element element = ManifestAttributeEditor.this.getElementBinding().getElement();
                        String elementName = element.getName();
                        Element ref_element = null;
                        if (elementName.equals("item") || elementName.equals("dependency")) {
                            if (att.getName().equals("identifierref")) {
                                ref_element = cp.getReferencedElement(element);
                            }
                        } else if (elementName.equals("organizations") && att.getName().equals("default")) {
                            ref_element = cp.getDefaultOrganization(element);
                        }
                        if (ref_element != null) {
                            return cp.getElementDisplayName(ref_element);
                        }
                    }
                    return super.getValueAt(rowIndex, columnIndex);
                }
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }
}

