/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.AbstractList;
import javax.swing.JDesktopPane;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.dweezil.dnd.DNDUtils;
import uk.ac.reload.editor.EditorHandler;

public class EditorDesktopPane
extends JDesktopPane
implements DropTargetListener {
    public EditorDesktopPane() {
        new DropTarget(this, this);
    }

    protected void openFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            String ext = FileUtils.getFileExtension((File)files[i]);
            if (!ext.equals("zip") && !ext.equals("xml") || !files[i].exists()) continue;
            EditorHandler.getSharedInstance().openFile(files[i]);
        }
    }

    public void drop(DropTargetDropEvent event) {
        Transferable transferable = event.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            event.acceptDrop(DNDUtils.getCorrectDropContext((DropTargetDropEvent)event));
            try {
                Object userObject = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (userObject instanceof AbstractList) {
                    AbstractList list = (AbstractList)userObject;
                    Object[] files = list.toArray();
                    this.openFiles((File[])files);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            event.getDropTargetContext().dropComplete(true);
        } else {
            event.rejectDrop();
        }
    }

    public boolean isDropOK(DropTargetDragEvent event) {
        DataFlavor[] flavors = event.getCurrentDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(DNDUtils.getCorrectDropContext((DropTargetDragEvent)event));
        } else {
            event.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(DNDUtils.getCorrectDropContext((DropTargetDragEvent)event));
        } else {
            event.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(DNDUtils.getCorrectDropContext((DropTargetDragEvent)event));
        } else {
            event.rejectDrag();
        }
    }
}

