/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.io.File;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.ac.reload.diva.prefs.UserPrefs;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.properties.EditorProperties;

public class EditorPrefs
extends UserPrefs {
    public static final String USER_PREFS_FILENAME = "reload_prefs.xml";
    public static final String USER_PREFS_ELEMENTNAME = "reload_prefs";
    private static EditorPrefs _userPrefs = new EditorPrefs();
    public static final String GENERAL_PREFS_DEFAULT_FOLDER = "default_folder";
    public static final String GENERAL_PREFS_LF = "look_and_feel";
    public static final String GENERAL_HISTORY = "history";
    public static final String GENERAL_CHECK_SUPPORT = "check_support";
    public static final String CP_HIDE_RESOURCES = "hide_resources";
    public static final String CP_HIDE_SCORM = "hide_scorm";
    public static final String CP_DEFAULT_PROFILE = "default_cp_profile";
    public static final String CP_DEFAULT_CP_VERSION = "default_cp_version";
    public static final String CP_DEFAULT_MD_VERSION = "default_cp_md_version";
    public static final String SCORM_DEFAULT_PROFILE = "default_scorm_profile";
    public static final String SCORM_DEFAULT_CP_VERSION = "default_scorm_cp_version";
    public static final String SCORM_DEFAULT_MD_VERSION = "default_scorm_md_version";
    public static final String MD_DEFAULT_PROFILE = "default_md_profile";
    public static final String MD_DEFAULT_VERSION = "default_md_version";
    public static final String MD_DO_ASK_VERSION = "do_ask_md_version";
    public static final String LANGUAGE = "language";
    public static final String DEFAULT_LANGUAGE = "(default)";

    public static EditorPrefs getInstance() {
        return _userPrefs;
    }

    protected void setDefaultValues() {
        String value = this.getValue(CP_HIDE_RESOURCES);
        if (value == null) {
            this.putBooleanValue(CP_HIDE_RESOURCES, false);
        }
        if ((value = this.getValue(CP_HIDE_SCORM)) == null) {
            this.putBooleanValue(CP_HIDE_SCORM, true);
        }
        if ((value = this.getValue(GENERAL_CHECK_SUPPORT)) == null) {
            this.putBooleanValue(GENERAL_CHECK_SUPPORT, true);
        }
        if ((value = this.getValue(MD_DO_ASK_VERSION)) == null) {
            this.putBooleanValue(MD_DO_ASK_VERSION, true);
        }
        if ((value = this.getValue(MD_DEFAULT_VERSION)) == null) {
            this.putValue(MD_DEFAULT_VERSION, EditorHandler.MD_EDITORHANDLER.getDefaultVersion());
        }
        if ((value = this.getValue(CP_DEFAULT_CP_VERSION)) == null) {
            this.putValue(CP_DEFAULT_CP_VERSION, EditorHandler.CP_EDITORHANDLER.getDefaultVersion());
        }
        if ((value = this.getValue(CP_DEFAULT_MD_VERSION)) == null) {
            this.putValue(CP_DEFAULT_MD_VERSION, EditorHandler.MD_EDITORHANDLER.getDefaultVersion());
        }
        if ((value = this.getValue(SCORM_DEFAULT_CP_VERSION)) == null) {
            this.putValue(SCORM_DEFAULT_CP_VERSION, EditorHandler.SCORM12_EDITORHANDLER.getDefaultVersion());
        }
        if ((value = this.getValue(SCORM_DEFAULT_MD_VERSION)) == null) {
            this.putValue(SCORM_DEFAULT_MD_VERSION, EditorHandler.SCORM12_EDITORHANDLER.getDefaultMDVersion());
        }
        if ((value = this.getValue(LANGUAGE)) == null) {
            this.putValue(LANGUAGE, DEFAULT_LANGUAGE);
        }
    }

    public File getPrefsFile() {
        return new File(this.getPrefsFolder(), USER_PREFS_FILENAME);
    }

    public File getPrefsFolder() {
        File reloadHome = EditorProperties.getFileProperty("prefs.dir");
        if (reloadHome != null) {
            reloadHome.mkdirs();
        }
        return reloadHome;
    }

    public String getElementRootName() {
        return USER_PREFS_ELEMENTNAME;
    }

    public String[] getFileHistory() {
        Vector<String> v = new Vector<String>();
        String val = this.getValue(GENERAL_HISTORY);
        if (val != null) {
            StringTokenizer t = new StringTokenizer(val, ";");
            while (t.hasMoreElements()) {
                String path = t.nextToken();
                v.addElement(path);
            }
        }
        Object[] vals = new String[v.size()];
        v.copyInto(vals);
        return vals;
    }

    public void addFileToHistory(File file) {
        String val = file.getPath();
        int count = 1;
        String[] history = this.getFileHistory();
        for (int i = 0; i < history.length && count < 8; ++i) {
            if (history[i].equalsIgnoreCase(file.getPath())) continue;
            val = val + ";" + history[i];
            ++count;
        }
        this.putValue(GENERAL_HISTORY, val);
    }

    public void setDefaultLocale() {
        String languageCode = this.getValue(LANGUAGE);
        if (languageCode != null && !languageCode.equals(DEFAULT_LANGUAGE)) {
            this.setDefaultLocale(languageCode);
        }
    }

    public void setDefaultLocale(String languageCode) {
        if (languageCode != null) {
            StringTokenizer t = new StringTokenizer(languageCode, "_");
            int tokens = t.countTokens();
            if (tokens == 1) {
                Locale.setDefault(new Locale(languageCode));
            } else if (tokens == 2) {
                String language = t.nextToken();
                String country = t.nextToken();
                Locale.setDefault(new Locale(language, country));
            } else if (tokens >= 3) {
                String language = t.nextToken();
                String country = t.nextToken();
                String variant = t.nextToken();
                while (t.hasMoreTokens()) {
                    variant = variant + "_" + t.nextToken();
                }
                Locale.setDefault(new Locale(language, country, variant));
            }
        }
    }
}

