/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import uk.ac.reload.diva.prefs.UserPrefs;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.prefs.PrefsPanel;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.Messages;

public class AppearancePrefsPanel
extends PrefsPanel {
    private JComboBox _lfComboBox;
    private UIManager.LookAndFeelInfo[] systemLookAndFeels = UIManager.getInstalledLookAndFeels();
    private String _oldLF;
    private boolean _updateLFCombo;
    private JComboBox _lfLanguageBox;
    private Language[] _installedLanguages;

    public AppearancePrefsPanel() {
        this.setLayout((LayoutManager)new XYLayout());
        this.initGUI();
    }

    private void initGUI() {
        LookAndFeel[] installedLookAndFeels = new LookAndFeel[this.systemLookAndFeels.length];
        for (int i = 0; i < this.systemLookAndFeels.length; ++i) {
            installedLookAndFeels[i] = new LookAndFeel(this.systemLookAndFeels[i]);
        }
        this._lfComboBox = new JComboBox<LookAndFeel>(installedLookAndFeels);
        int x = 10;
        int y = 10;
        this.add(new JLabel(Messages.getString("uk.ac.reload.editor.prefs.AppearancePrefsPanel.0")), new XYConstraints(x, y, 0, 0));
        this.add(this._lfComboBox, new XYConstraints(x + 230, y, 200, 22));
        this._lfComboBox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (AppearancePrefsPanel.this._updateLFCombo) {
                    AppearancePrefsPanel.this.setAppearance(((LookAndFeel)AppearancePrefsPanel.this._lfComboBox.getSelectedItem()).getClassName());
                }
            }
        });
        y += 30;
        Locale[] locales = Locale.getAvailableLocales();
        this._installedLanguages = new Language[locales.length];
        this._installedLanguages[0] = new Language();
        for (int i = 1; i < locales.length; ++i) {
            this._installedLanguages[i] = new Language(locales[i]);
        }
        Arrays.sort(this._installedLanguages);
        this._lfLanguageBox = new JComboBox<Language>(this._installedLanguages);
        this.add(new JLabel(Messages.getString("uk.ac.reload.editor.prefs.AppearancePrefsPanel.1")), new XYConstraints(x, y, 0, 0));
        this.add(this._lfLanguageBox, new XYConstraints(x + 230, y, 200, 22));
    }

    public void saveToUserPrefs(UserPrefs prefs) {
        prefs.putValue("look_and_feel", ((LookAndFeel)this._lfComboBox.getSelectedItem()).getClassName());
        Language language = (Language)this._lfLanguageBox.getSelectedItem();
        prefs.putValue("language", language.getLanguage());
    }

    public void setFields(UserPrefs prefs) {
        this._oldLF = UIManager.getLookAndFeel().getClass().getName();
        this._updateLFCombo = false;
        if (this._oldLF != null) {
            for (int i = 0; i < this.systemLookAndFeels.length; ++i) {
                if (!this.systemLookAndFeels[i].getClassName().equals(this._oldLF)) continue;
                this._lfComboBox.setSelectedIndex(i);
                break;
            }
        }
        this._updateLFCombo = true;
        String language = prefs.getValue("language");
        if (language != null && this._installedLanguages != null) {
            for (int i = 0; i < this._installedLanguages.length; ++i) {
                if (!language.equals(this._installedLanguages[i].getLanguage())) continue;
                this._lfLanguageBox.setSelectedItem(this._installedLanguages[i]);
            }
        }
    }

    public void setAppearance(String className) {
        DweezilUIManager.setLookAndFeel((String)className, (Component[])new Component[]{EditorFrame.getInstance(), EditorFrame.getInstance().getStatusWindow(), this.getParent().getParent()});
    }

    public void cancel() {
        String currentLF;
        if (this._oldLF != null && !this._oldLF.equals(currentLF = UIManager.getLookAndFeel().getClass().getName())) {
            this.setAppearance(this._oldLF);
        }
    }

    private class Language
    implements Comparable {
        private Locale locale;

        public Language() {
            this.locale = null;
        }

        public Language(Locale locale) {
            this.locale = locale;
        }

        public String getLanguage() {
            if (this.locale == null) {
                return "(default)";
            }
            return this.locale.toString();
        }

        public String toString() {
            if (this.locale == null) {
                return "(default)";
            }
            return this.locale.getDisplayName();
        }

        public int compareTo(Object o) {
            if (o instanceof Language) {
                Language language = (Language)o;
                return this.toString().compareTo(language.toString());
            }
            return 0;
        }
    }

    private class LookAndFeel {
        private UIManager.LookAndFeelInfo lookAndFeelInfo;

        public LookAndFeel(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this.lookAndFeelInfo = lookAndFeelInfo;
        }

        public String toString() {
            return this.lookAndFeelInfo.getName();
        }

        public String getClassName() {
            return this.lookAndFeelInfo.getClassName();
        }
    }
}

