/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.formview;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.reload.editor.gui.widgets.NumberFieldWidget;
import uk.ac.reload.editor.gui.widgets.TextAreaWidget;
import uk.ac.reload.editor.gui.widgets.TextFieldWidget;
import uk.ac.reload.editor.gui.widgets.Widget;
import uk.ac.reload.editor.metadata.editor.formview.MD_Field;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaNode;

public class MD_TextField
extends MD_Field
implements DocumentListener {
    private boolean _allowNotification = true;
    private Widget _widget;

    public MD_TextField(Metadata metadata, SchemaElement schemaElement) {
        super(metadata, schemaElement);
        this._widget = this.getMetadataTextFieldWidget(schemaElement);
        ((JComponent)((Object)this._widget)).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setElement(metadata.getElement(this.getSchemaElement()));
        if (this.getElement() != null) {
            this.setValue(this.getElement().getText());
        }
        this._widget.addDocumentListener(this);
        metadata.addXMLDocumentListener(this);
    }

    protected Widget getMetadataTextFieldWidget(SchemaElement schemaElement) {
        if (schemaElement == null) {
            return this.getDefaultWidget();
        }
        Widget component = null;
        SchemaController schemaController = this.getSchemaDocument().getSchemaController();
        String widget_type = schemaController.getWidgetType(schemaElement.getXMLPath());
        if (widget_type != null) {
            if (widget_type.equals("textpane")) {
                component = new TextAreaWidget();
                ((TextAreaWidget)component).setColumns(50);
            } else if (widget_type.equals("numberfield")) {
                component = new NumberFieldWidget();
                ((NumberFieldWidget)component).setColumns(30);
            } else {
                component = this.getDefaultWidget();
            }
        } else {
            component = this.getDefaultWidget();
        }
        int maxLength = -1;
        String value = schemaController.getFacetValue((SchemaNode)schemaElement, "maxLength");
        if (value != null) {
            maxLength = Integer.parseInt(value);
        }
        component.setMaxLength(maxLength);
        return component;
    }

    private Widget getDefaultWidget() {
        TextFieldWidget textField = new TextFieldWidget();
        textField.setColumns(50);
        return textField;
    }

    public void cleanup() {
        this._widget.removeDocumentListener(this);
        this.getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
    }

    public String getValue() {
        return this._widget.getTextValue();
    }

    public void setValue(String value) {
        this._allowNotification = false;
        this._widget.setTextValue(value);
        this._allowNotification = true;
    }

    public Component getComponent() {
        return (Component)((Object)this._widget);
    }

    public void removeUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    public void changedUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }
}

