/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.resources;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import uk.ac.reload.dweezil.dnd.DNDUtils;
import uk.ac.reload.dweezil.dnd.DragObject;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeDragDropHandler;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.contentpackaging.datamodel.CP_Resource;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.gui.Editor_Tree;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.gui.Editor_TreeRenderer;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resource;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resources;
import uk.ac.reload.editor.learningdesign.editor.resources.LD_ResourcesTreeModel;

public class LD_ResourcesTree
extends Editor_Tree {
    private ResourcesTreeDragDropHandler _dragdropHandler;

    public LD_ResourcesTree() {
        this.setEditor_TreeModel(new LD_ResourcesTreeModel(this));
        this.setCellRenderer(new Editor_TreeRenderer());
        this._dragdropHandler = new ResourcesTreeDragDropHandler(this);
    }

    public void setDataModel(DataModel dataModel) {
        super.setDataModel(dataModel);
        this.expandNode((DefaultMutableTreeNode)this.getEditor_TreeModel().getRootNode(), true);
        this.selectRootNode();
    }

    class ResourcesTreeDragDropHandler
    extends DweezilTreeDragDropHandler {
        public ResourcesTreeDragDropHandler(DweezilTree tree) {
            super(tree);
        }

        public boolean isDropOK(DropTargetDragEvent event) {
            Editor_TreeNode targetNode = (Editor_TreeNode)((Object)this.getDragOverTreeNode(event));
            if (targetNode == null) {
                return false;
            }
            DropTargetDropEvent tempDTDropEvent = new DropTargetDropEvent(event.getDropTargetContext(), event.getLocation(), 1, 0);
            Transferable transferable = tempDTDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DragObject.flavor)) {
                int action = DNDUtils.getCorrectDropContext((DropTargetDragEvent)event);
                if ((action & 1) != 0 || (action & 2) != 0) {
                    try {
                        Object userObject = transferable.getTransferData(DragObject.flavor);
                        if (userObject instanceof CP_Resource[]) {
                            LD_Component ldComponent = (LD_Component)targetNode.getUserObject();
                            return ldComponent instanceof LD_Resources || ldComponent instanceof LD_Resource;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent event) {
            Point location = event.getLocation();
            TreePath treePath = LD_ResourcesTree.this.getPathForLocation(location.x, location.y);
            if (treePath == null) {
                return;
            }
            Editor_TreeNode targetNode = (Editor_TreeNode)((Object)treePath.getLastPathComponent());
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DragObject.flavor)) {
                event.acceptDrop(DNDUtils.getCorrectDropContext((DropTargetDropEvent)event));
                try {
                    Object userObject = transferable.getTransferData(DragObject.flavor);
                    int action = DNDUtils.getCorrectDropContext((DropTargetDropEvent)event);
                    LD_ResourcesTree.this.setCursor(DweezilUIManager.WAIT_CURSOR);
                    if (userObject instanceof CP_Resource[]) {
                        LD_Component ldComponent = (LD_Component)targetNode.getUserObject();
                        Element element = ldComponent.getElement();
                        Element newElement = ((LD_DataModel)LD_ResourcesTree.this.getDataModel()).getLearningDesign().addCP_Resources((CP_Resource[])userObject, element);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    LD_ResourcesTree.this.setCursor(DweezilUIManager.DEFAULT_CURSOR);
                }
                this.hiliteNode(this._prevHilitedNode, false);
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
    }
}

