/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.general;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.PaddedPanel;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.editor.general.OverViewPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.ItemModelTypePanel;

public class GeneralPanel
extends GradientPanel
implements ILD_DataModelHandler {
    private LD_DataModel _ldDataModel;
    private OverViewPanel _overViewPanel;
    private ItemModelTypePanel _objectivesPanel;
    private ItemModelTypePanel _prereqPanel;
    static final double RIGHTPAD = 0.5;

    public GeneralPanel() {
        super((LayoutManager)new BorderLayout());
        JLabel label = new JLabel("General");
        label.setFont(label.getFont().deriveFont(1, 16.0f));
        this.add(label, "North");
        ScrollPanel padPanel = new ScrollPanel(1, 0.5);
        JScrollPane sp = new JScrollPane((Component)((Object)padPanel));
        sp.setBorder(null);
        this.add(sp, "Center");
        JPanel subPanel = new JPanel();
        padPanel.add(subPanel);
        subPanel.setOpaque(false);
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        RelativeLayoutManager layoutManager = new RelativeLayoutManager((Container)subPanel);
        this._overViewPanel = new OverViewPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)this._overViewPanel, "_overViewPanel", "_container", 2, 10, 10);
        this._objectivesPanel = new ItemModelTypePanel(false);
        layoutManager.addFromLeftToRightEdges((JComponent)this._objectivesPanel, "_objectivesPanel", "_overViewPanel", 1, 40, 10);
        this._prereqPanel = new ItemModelTypePanel(false);
        layoutManager.addFromLeftToRightEdges((JComponent)this._prereqPanel, "_prereqPanel", "_objectivesPanel", 1, 40, 10);
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        this._overViewPanel.setDataModel(ldDataModel);
        this._objectivesPanel.setItemModelType(ldDataModel.getLearningObjectives());
        this._prereqPanel.setItemModelType(ldDataModel.getPrerequisites());
    }

    protected void setupView() {
        super.setupView();
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        this.setBorder(border);
    }

    public void cleanup() {
        this._overViewPanel.cleanup();
        this._objectivesPanel.cleanup();
        this._prereqPanel.cleanup();
        this._ldDataModel = null;
    }

    public boolean doSave() {
        return this._overViewPanel.doSave();
    }

    class ScrollPanel
    extends PaddedPanel
    implements Scrollable {
        public ScrollPanel(int type, double padFactor) {
            super(type, padFactor);
        }

        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
            }
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
            }
            return false;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }
    }
}

