/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.activities;

import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.IdentifierLabelTextField;
import uk.ac.reload.editor.gui.TitledEditorPanel;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activity;
import uk.ac.reload.editor.learningdesign.editor.activities.ActivityEnvironmentsListPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.IsVisibleParametersPanel;

public abstract class ActivityEditorPanel
extends TitledEditorPanel {
    static final boolean SHOW_IDENTIFIER = false;
    protected ActivityEnvironmentsListPanel _envListPanel;
    protected IdentifierLabelTextField _tfIdentifier;
    protected IsVisibleParametersPanel _isVisibleParametersPanel;

    protected ActivityEditorPanel() {
    }

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        this.getTitleLabel().setComponent(dataComponent);
        DataElement activityElement = dataComponent.getDataElement();
        this._isVisibleParametersPanel.getIsVisibleCheckBox().setAttribute(activityElement, "isvisible", true);
        this._isVisibleParametersPanel.getParametersField().setAttribute(activityElement, "parameters", null);
        this._envListPanel.setActivity((Activity)dataComponent);
    }

    protected void setupView() {
        super.setupView();
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        SGLayout fieldPanelLayout = new SGLayout(1, 1, 0, 5);
        JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
        fieldPanel.setOpaque(false);
        layoutManager.addFromLeftToRightEdges((JComponent)fieldPanel, "fieldPanel", "TitledEditorPanel.TOPPANEL_ID", 1, 10, 10);
        this._isVisibleParametersPanel = new IsVisibleParametersPanel();
        fieldPanel.add(this._isVisibleParametersPanel);
    }

    protected ActivityEnvironmentsListPanel addEnvironmentListPanel(String parentAnchor) {
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        ComponentHiderLabelPanel envpicker_hider = new ComponentHiderLabelPanel("Environments", "Add Environments that this Activity references.");
        layoutManager.addFromLeftToRightEdges((JComponent)envpicker_hider, "envpicker_hider", parentAnchor, 1, 15, 10);
        ActivityEnvironmentsListPanel listPanel = new ActivityEnvironmentsListPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)((Object)listPanel), "envlistPanel", "envpicker_hider", 1, 5, 10);
        envpicker_hider.getComponentHiderButton().setComponent((JComponent)((Object)listPanel));
        envpicker_hider.getComponentHiderButton().showComponent(false);
        return listPanel;
    }

    public void cleanup() {
        super.cleanup();
        if (this._envListPanel != null) {
            this._envListPanel.cleanup();
        }
    }
}

