/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import java.util.Iterator;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Conference;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.IndexSearch;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Monitor;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.SendMail;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;

public class Service_Grouping
extends LD_Grouping
implements IDataComponentIcon {
    static final String TITLE = "Services";
    static final String DESCRIPTION = "Add Services to the Learning Design.";

    public Service_Grouping(LD_DataModel ldDataModel, Environment environment) {
        this.setDataModel(ldDataModel);
        this.setElement(environment.getElement());
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.addChildren();
    }

    protected void addChildren() {
        Iterator it = this.getElement().getChildren("service", this.getElement().getNamespace()).iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            LD_Component ldComponent = this.createComponent(element);
            if (ldComponent == null) continue;
            this.addChild(ldComponent);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!this.isService(elementName)) {
            return null;
        }
        LD_Component ldComponent = null;
        Element parentElement = this.addChildElement(this.getElement(), "service");
        Element element = this.addChildElement(parentElement, elementName);
        if (element != null && (ldComponent = this.createComponent(element)) != null) {
            this.addChild(ldComponent);
            if (title != null) {
                ldComponent.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(ldComponent);
        }
        return ldComponent;
    }

    private LD_Component createComponent(Element element) {
        if (element == null) {
            return null;
        }
        if ("service".equals(element.getName()) && (element = (Element)element.getChildren().get(0)) == null) {
            return null;
        }
        Service ldComponent = null;
        String elementName = element.getName();
        if ("send-mail".equals(elementName)) {
            ldComponent = new SendMail(this.getLD_DataModel(), element);
        } else if ("conference".equals(elementName)) {
            ldComponent = new Conference(this.getLD_DataModel(), element);
        } else if ("index-search".equals(elementName)) {
            ldComponent = new IndexSearch(this.getLD_DataModel(), element);
        } else if ("monitor".equals(elementName)) {
            ldComponent = new Monitor(this.getLD_DataModel(), element);
        }
        return ldComponent;
    }

    private boolean isService(String elementName) {
        return "send-mail".equals(elementName) || "conference".equals(elementName) || "index-search".equals(elementName) || "monitor".equals(elementName);
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/service.gif");
    }
}

