/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.activities;

import java.util.Iterator;
import java.util.Vector;
import org.jdom.Element;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.ActivityStructure;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.LearningActivity;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.SupportActivity;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;

public abstract class Activity
extends LD_Component
implements IDataComponentIcon {
    protected Activity(LD_DataModel ldDataModel, Element element) {
        this.setDataModel(ldDataModel);
        this.setElement(element);
        ldDataModel.addIDataModelListener(this);
    }

    public void setElement(Element element) {
        super.setElement(element);
        this.ensureTitleElement();
    }

    public void setTitle(String title) {
        this.setTitleElement(title);
    }

    public Environment[] getEnvironments() {
        Vector<LD_Component> v = new Vector<LD_Component>();
        Iterator it = this.getElement().getChildren("environment-ref", this.getElement().getNamespace()).iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String ref = element.getAttributeValue("ref");
            LD_Component component = this.getLD_DataModel().getEnvironment_Grouping().getChildByIdentifer(ref);
            if (component == null) continue;
            v.add(component);
        }
        Object[] envs = new Environment[v.size()];
        v.copyInto(envs);
        return envs;
    }

    protected boolean ensureAllReferences() {
        return this.ensureReferences(this.getElement(), "environment-ref", "ref", this.getLD_DataModel().getEnvironment_Grouping());
    }

    public void addRef(LD_Component component) {
        String elementName = this.getElementRefName(component);
        if (elementName != null) {
            this.addRef(component, this.getElement(), elementName, "ref");
        }
    }

    public void removeRef(LD_Component component) {
        String elementName = this.getElementRefName(component);
        if (elementName != null) {
            this.removeRef(component, this.getElement(), elementName, "ref");
        }
    }

    public void moveRefUp(LD_Component component) {
        String elementName = this.getElementRefName(component);
        if (elementName != null) {
            this.moveRefUp(component, this.getElement(), elementName, "ref");
        }
    }

    public void moveRefDown(LD_Component component) {
        String elementName = this.getElementRefName(component);
        if (elementName != null) {
            this.moveRefDown(component, this.getElement(), elementName, "ref");
        }
    }

    private String getElementRefName(LD_Component component) {
        if (component instanceof Role) {
            return "role-ref";
        }
        if (component instanceof Environment) {
            return "environment-ref";
        }
        if (component instanceof LearningActivity) {
            return "learning-activity-ref";
        }
        if (component instanceof SupportActivity) {
            return "support-activity-ref";
        }
        if (component instanceof ActivityStructure) {
            return "activity-structure-ref";
        }
        return null;
    }

    protected void moveElementUp() {
        this.moveElementUpSameType();
    }

    protected void moveElementDown() {
        this.moveElementDownSameType();
    }

    public void componentRemoved(DataComponent component) {
        boolean modified = this.ensureAllReferences();
        if (modified) {
            this.getDataModel().fireDataComponentChanged(this);
        }
    }
}

