/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.editor.menu.MainMenu;

public class NotesPanel
extends JPanel
implements DocumentListener {
    private ProxySaveHandler _saveHandler;
    private ProxySaveHandler _saveAsHandler;
    private JScrollPane _scrollPane;
    private JTextPane _textPane;
    private JLabel _label;
    private ComponentHiderLabelPanel _hiderPanel;
    private File _file;
    private boolean _doNotify = true;
    private boolean _isDirty;

    public NotesPanel(String labelText, String decriptionText) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this._textPane = new JTextPane();
        this._textPane.setFont(this._textPane.getFont().deriveFont(12.0f));
        this._textPane.getDocument().addDocumentListener(this);
        this._scrollPane = new JScrollPane(this._textPane);
        this._scrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this._scrollPane.setPreferredSize(new Dimension(100, 100));
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.setOpaque(false);
        subPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        subPanel.add(this._scrollPane);
        this._hiderPanel = new ComponentHiderLabelPanel(labelText, decriptionText);
        this._hiderPanel.getComponentHiderButton().setComponent((JComponent)subPanel);
        this.add((Component)this._hiderPanel, "North");
        this.add((Component)subPanel, "Center");
        this._saveHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSave);
        this._saveAsHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSaveAs);
    }

    public void showTextPane(boolean show) {
        this._hiderPanel.getComponentHiderButton().showComponent(show);
    }

    public void setTextFont(Font font) {
        this._textPane.setFont(font);
    }

    public void setPreferredSize(Dimension d) {
        this._scrollPane.setPreferredSize(d);
    }

    public void cleanup() {
        this._saveHandler.removeListener();
        this._saveAsHandler.removeListener();
    }

    public JTextPane getTextPane() {
        return this._textPane;
    }

    public void loadFile(File file) throws IOException {
        this._file = file;
        if (this._file != null && this._file.exists()) {
            int nch;
            FileReader in = new FileReader(this._file);
            char[] buff = new char[4096];
            Document doc = this._textPane.getDocument();
            this._doNotify = false;
            while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                try {
                    doc.insertString(doc.getLength(), new String(buff, 0, nch), null);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
            this._doNotify = true;
            ((Reader)in).close();
            this._saveHandler.addListener();
            this._saveAsHandler.addListener();
        }
    }

    public boolean saveDocument() {
        if (this._file != null && this._isDirty) {
            try {
                this._file.getParentFile().mkdirs();
                FileWriter out = new FileWriter(this._file);
                out.write(this._textPane.getText());
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        this._saveHandler.setEnabled(false);
        this._isDirty = false;
        return true;
    }

    public void changedUpdate(DocumentEvent e) {
        this.notifyTextChange();
    }

    public void insertUpdate(DocumentEvent e) {
        this.notifyTextChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.notifyTextChange();
    }

    protected void notifyTextChange() {
        if (this._doNotify) {
            this._isDirty = true;
            this._saveHandler.setEnabled(true);
        }
    }

    class ProxySaveHandler
    extends ProxyAction {
        public ProxySaveHandler(MenuAction menuAction) {
            super(menuAction);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (event.getSource() == MainMenu.getSharedInstance().actionSave) {
                NotesPanel.this.saveDocument();
            }
            if (event.getSource() == MainMenu.getSharedInstance().actionSaveAs) {
                // empty if block
            }
        }
    }
}

