/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.manifestview;

import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeModel;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.editor.manifestview.ManifestTreeNode;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class ManifestTreeModel
extends DweezilTreeModel {
    private ContentPackage _contentPackage;

    public void setContentPackage(ContentPackage cp) {
        this._contentPackage = cp;
        this.root = new ManifestTreeNode(this._contentPackage);
        this.buildChildren((ManifestTreeNode)((Object)this.root));
        this.reload();
    }

    public void buildChildren(ManifestTreeNode node) {
        Iterator children = node.getElement().getChildren().iterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!this.doShowNode(child)) continue;
            ManifestTreeNode newNode = new ManifestTreeNode(child);
            node.add((MutableTreeNode)((Object)newNode));
            this.buildChildren(newNode);
        }
    }

    protected boolean doShowNode(Element element) {
        return this.doShowNode(element.getName(), element.getNamespace());
    }

    protected boolean doShowNode(SchemaElement schemaElement) {
        return this.doShowNode(schemaElement.getName(), schemaElement.getNamespace());
    }

    protected boolean doShowNode(String elementName, Namespace ns) {
        if (this._contentPackage.isMetadataRoot(elementName)) {
            return false;
        }
        if (elementName.equals("title") && ns.equals((Object)this._contentPackage.getRootNamespace())) {
            return false;
        }
        if (ns.equals((Object)CP_EditorHandler.ADLCP_NAMESPACE_12)) {
            if (!elementName.equals("location")) {
                boolean hideSCORM = EditorPrefs.getInstance().getBooleanValue("hide_scorm");
                return !hideSCORM;
            }
            return true;
        }
        if (elementName.equals("resources")) {
            boolean hideResources = EditorPrefs.getInstance().getBooleanValue("hide_resources");
            return !hideResources;
        }
        return true;
    }

    protected boolean canAddNode(Element element) {
        return this.canAddNode(element.getName(), element.getNamespace());
    }

    protected boolean canAddNode(SchemaElement schemaElement) {
        return this.canAddNode(schemaElement.getName(), schemaElement.getNamespace());
    }

    protected boolean canAddNode(String elementName, Namespace ns) {
        if (elementName.equals("manifest") && ns.equals((Object)this._contentPackage.getRootNamespace())) {
            return false;
        }
        if (elementName.equals("organizations") && ns.equals((Object)this._contentPackage.getRootNamespace())) {
            return false;
        }
        if (elementName.equals("resources") && ns.equals((Object)this._contentPackage.getRootNamespace())) {
            return false;
        }
        return this.doShowNode(elementName, ns);
    }
}

