/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileFilter;
import uk.ac.reload.dweezil.gui.DweezilFileFilter;
import uk.ac.reload.dweezil.gui.DweezilInternalFrame;
import uk.ac.reload.dweezil.gui.DweezilInternalFrameManager;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.ApplicationListener;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.EditorOpenDialog;
import uk.ac.reload.editor.IEditorHandler;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.learningdesign.LD_EditorHandler;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.metadata.MD_EditorHandler;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.editor.scorm.SCORM12_EditorHandler;
import uk.ac.reload.editor.simplesequencing.SS_EditorHandler;
import uk.ac.reload.moonunit.SchemaController;

public final class EditorHandler
implements InternalFrameListener {
    public static File HELPERFOLDER = EditorProperties.getFileProperty("helpers.dir");
    public static File SCHEMAROOTFOLDER = EditorProperties.getFileProperty("schema.dir");
    public static File SCHEMAMODELFOLDER = new File(SCHEMAROOTFOLDER, "model");
    public static File SCHEMASHIPPEDFOLDER = new File(SCHEMAROOTFOLDER, "shipped");
    public static MD_EditorHandler MD_EDITORHANDLER = new MD_EditorHandler();
    public static CP_EditorHandler CP_EDITORHANDLER = new CP_EditorHandler();
    public static SCORM12_EditorHandler SCORM12_EDITORHANDLER = new SCORM12_EditorHandler();
    public static LD_EditorHandler LD_EDITORHANDLER = new LD_EditorHandler();
    private static EditorHandler _sharedInstance;
    private Vector _editorHandlers = new Vector();
    private Vector _applisteners = new Vector();
    private DweezilInternalFrameManager _internalFrameManager;

    public static EditorHandler getSharedInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new EditorHandler();
        }
        return _sharedInstance;
    }

    private EditorHandler() {
    }

    public void registerDesktop(JDesktopPane deskTop) {
        this._internalFrameManager = new DweezilInternalFrameManager(deskTop);
    }

    public void registerInbuiltEditorHandlers() {
        this.registerEditorHandler(MD_EDITORHANDLER);
        this.registerEditorHandler(CP_EDITORHANDLER);
        this.registerEditorHandler(SCORM12_EDITORHANDLER);
        this.registerEditorHandler(LD_EDITORHANDLER);
        if (EditorProperties.getString("DEBUG").equals("true")) {
            this.registerEditorHandler(new SS_EditorHandler());
        }
    }

    public void openFile() {
        DweezilFileFilter filter = new DweezilFileFilter(new String[]{"xml", "zip"}, Messages.getString("uk.ac.reload.editor.EditorHandler.1"));
        File file = EditorOpenDialog.askFileNameOpen(null, Messages.getString("uk.ac.reload.editor.EditorHandler.2"), (FileFilter)filter);
        if (file == null) {
            return;
        }
        this.openFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(File file) {
        DweezilInternalFrame frame = DweezilInternalFrameManager.getInternalFrame((File)file);
        if (frame != null) {
            try {
                frame.setIcon(false);
                frame.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
            return;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.EditorHandler.3") + ": " + file, Messages.getString("uk.ac.reload.editor.EditorHandler.4"), 2);
            return;
        }
        IEditorHandler handler = null;
        try {
            EditorFrame.getInstance().setCursor(DweezilUIManager.WAIT_CURSOR);
            handler = this.getEditorHandler(file);
            if (handler != null) {
                EditorInternalFrame iframe = handler.editFile(file);
                if (iframe == null) {
                    return;
                }
                final EditorInternalFrame iframe2 = iframe;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorHandler.this.addInternalFrame(iframe2);
                        iframe2.show();
                    }
                });
                this.registerOpenedFile(file, iframe);
            } else {
                JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.EditorHandler.5") + "\r\n" + Messages.getString("uk.ac.reload.editor.EditorHandler.6"), EditorProperties.getString("APP_NAME"), 2);
            }
        }
        catch (Exception ex) {
            if (EditorProperties.getString("DEBUG").equals("true")) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning((String)(Messages.getString("uk.ac.reload.editor.EditorHandler.7") + ": " + file.getName()), (String)Messages.getString("uk.ac.reload.editor.EditorHandler.7"), (Exception)ex);
        }
        finally {
            EditorFrame.getInstance().setCursor(DweezilUIManager.DEFAULT_CURSOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorInternalFrame newDocument(IEditorHandler handler) {
        EditorInternalFrame iframe = null;
        try {
            EditorFrame.getInstance().setCursor(DweezilUIManager.WAIT_CURSOR);
            iframe = handler.newDocument();
            if (iframe != null) {
                this.addInternalFrame(iframe);
                iframe.show();
            }
        }
        catch (Exception ex) {
            if (EditorProperties.getString("DEBUG").equals("true")) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.EditorHandler.8"), (String)Messages.getString("uk.ac.reload.editor.EditorHandler.9"), (Exception)ex);
        }
        finally {
            EditorFrame.getInstance().setCursor(DweezilUIManager.DEFAULT_CURSOR);
        }
        return iframe;
    }

    public MenuAction[] getNewDocumentMenuActions() {
        Vector<2> v = new Vector<2>();
        IEditorHandler[] handlers = this.getRegisteredEditorHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            final IEditorHandler handler = handlers[i];
            if (!handler.canCreateDocuments()) continue;
            MenuAction action = new MenuAction(){

                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            2.access$100(this.this$1).newDocument(2.access$000(this.this$1));
                        }
                    };
                    thread.start();
                }

                static /* synthetic */ IEditorHandler access$000(2 x0) {
                    return x0.handler;
                }

                static /* synthetic */ EditorHandler access$100(2 x0) {
                    return x0.EditorHandler.this;
                }
            };
            action.setMenuIcon(handler.getIcon());
            action.setText(handler.getName());
            v.addElement(action);
        }
        Object[] actions = new MenuAction[v.size()];
        v.copyInto(actions);
        return actions;
    }

    public SchemaController getSchemaControllerInstance(String version) {
        IEditorHandler[] handlers = this.getRegisteredEditorHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            try {
                SchemaController schemaController = handlers[i].getSchemaControllerInstance(version);
                if (schemaController == null) continue;
                return schemaController;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void registerOpenedFile(File file, EditorInternalFrame frame) {
        DweezilInternalFrameManager.addInternalFrameToWindowMap((File)file, (DweezilInternalFrame)frame);
        EditorPrefs.getInstance().addFileToHistory(file);
    }

    public synchronized void registerEditorHandler(IEditorHandler handler) {
        if (!this._editorHandlers.contains(handler)) {
            this._editorHandlers.addElement(handler);
        }
    }

    public synchronized void removeEditorhandler(IEditorHandler handler) {
        this._editorHandlers.removeElement(handler);
    }

    public IEditorHandler[] getRegisteredEditorHandlers() {
        Object[] array = new IEditorHandler[this._editorHandlers.size()];
        this._editorHandlers.copyInto(array);
        return array;
    }

    public IEditorHandler getEditorHandler(File file) {
        IEditorHandler[] infos = this.getRegisteredEditorHandlers();
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].canEditFile(file)) continue;
            return infos[i];
        }
        return null;
    }

    public synchronized void addApplicationListener(ApplicationListener listener) {
        if (!this._applisteners.contains(listener)) {
            this._applisteners.addElement(listener);
        }
    }

    public synchronized void removeApplicationListener(ApplicationListener listener) {
        this._applisteners.removeElement(listener);
    }

    public void closeApplication() {
        boolean result = this.fireApplicationClosing();
        if (result) {
            try {
                EditorPrefs.getInstance().save();
            }
            catch (IOException ex) {
                ErrorDialogBox.showWarning((String)(Messages.getString("uk.ac.reload.editor.EditorHandler.10") + ": "), (String)Messages.getString("uk.ac.reload.editor.EditorHandler.11"), (Exception)ex);
            }
            System.exit(0);
        }
    }

    private boolean fireApplicationClosing() {
        boolean ok = true;
        for (int i = this._applisteners.size() - 1; i >= 0; --i) {
            ApplicationListener listener = (ApplicationListener)this._applisteners.elementAt(i);
            boolean result = listener.applicationClosing();
            if (result) continue;
            ok = false;
        }
        return ok;
    }

    public DweezilInternalFrameManager getInternalFrameManager() {
        return this._internalFrameManager;
    }

    public void addInternalFrame(EditorInternalFrame frame) {
        this.addInternalFrame(frame, true);
    }

    public void addInternalFrame(EditorInternalFrame frame, boolean autoSize) {
        this.addApplicationListener(frame);
        frame.addInternalFrameListener(this);
        this._internalFrameManager.addInternalFrame((DweezilInternalFrame)frame, autoSize);
        MainMenu.getSharedInstance().addInternalFrame(frame);
    }

    public void removeInternalFrame(EditorInternalFrame frame) {
        this.removeApplicationListener(frame);
        frame.removeInternalFrameListener(this);
        this._internalFrameManager.removeInternalFrame((DweezilInternalFrame)frame);
        MainMenu.getSharedInstance().removeInternalFrame(frame);
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        Object o = e.getSource();
        if (o instanceof EditorInternalFrame) {
            this.removeInternalFrame((EditorInternalFrame)o);
        }
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameActivated(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }
}

