/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import uk.ac.reload.diva.prefs.UserPrefs;
import uk.ac.reload.dweezil.gui.DweezilComboBox;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.prefs.PrefsPanel;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.metadata.MD_EditorHandler;
import uk.ac.reload.moonunit.HelperProfile;

public class MD_PrefsPanel
extends PrefsPanel {
    private DweezilComboBox _profileCombobox;
    private DweezilComboBox _versionCombobox;
    private JCheckBox _askversionCheckBox;

    public MD_PrefsPanel() {
        this.setLayout((LayoutManager)new XYLayout());
        this.constructFields();
    }

    private void constructFields() {
        int x = 10;
        int y = 10;
        JLabel label = new JLabel(Messages.getString("uk.ac.reload.editor.prefs.MD_PrefsPanel.0"));
        this.add(label, new XYConstraints(x, y + 2, 0, 0));
        this._profileCombobox = new DweezilComboBox(false);
        this.add((Component)this._profileCombobox, new XYConstraints(x += 230, y, 200, 22));
        x = 10;
        label = new JLabel(Messages.getString("uk.ac.reload.editor.prefs.MD_PrefsPanel.1"));
        this.add(label, new XYConstraints(x, (y += 30) + 2, 0, 0));
        this._versionCombobox = new DweezilComboBox(false);
        this.add((Component)this._versionCombobox, new XYConstraints(x += 230, y, 200, 22));
        x = 5;
        this._askversionCheckBox = new JCheckBox(Messages.getString("uk.ac.reload.editor.prefs.MD_PrefsPanel.2"));
        this.add(this._askversionCheckBox, new XYConstraints(x, y += 30, 0, 20));
    }

    public void saveToUserPrefs(UserPrefs prefs) {
        String version;
        String profile = (String)this._profileCombobox.getSelectedItem();
        if (profile != null) {
            prefs.putValue("default_md_profile", profile);
        }
        if ((version = (String)this._versionCombobox.getSelectedItem()) != null) {
            prefs.putValue("default_md_version", version);
        }
        prefs.putBooleanValue("do_ask_md_version", this._askversionCheckBox.isSelected());
    }

    public void setFields(UserPrefs prefs) {
        Object[] profiles = HelperProfile.getHelperProfileNames((File)MD_EditorHandler.PROFILE_FOLDER);
        this._profileCombobox.setItems(profiles);
        String profile = prefs.getValue("default_md_profile");
        if (profile != null) {
            this._profileCombobox.setSelectedItem((Object)profile);
        }
        Object[] versions = EditorHandler.MD_EDITORHANDLER.getSupportedVersions();
        this._versionCombobox.setItems(versions);
        String version = prefs.getValue("default_md_version");
        if (version != null) {
            this._versionCombobox.setSelectedItem((Object)version);
        }
        this._askversionCheckBox.setSelected(prefs.getBooleanValue("do_ask_md_version"));
    }

    public void cancel() {
    }
}

