/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import uk.ac.reload.diva.prefs.UserPrefs;
import uk.ac.reload.dweezil.gui.DweezilComboBox;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.prefs.PrefsPanel;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.scorm.SCORM12_EditorHandler;
import uk.ac.reload.moonunit.HelperProfile;

public class CP_PrefsPanel
extends PrefsPanel {
    private JCheckBox _checkbox_hideResources;
    private JCheckBox _checkbox_hideSCORM;
    private DweezilComboBox _profileCPCombobox;
    private DweezilComboBox _profileSCORMCombobox;

    public CP_PrefsPanel() {
        this.setLayout((LayoutManager)new XYLayout());
        this.constructFields();
    }

    private void constructFields() {
        int x = 5;
        int y = 10;
        this._checkbox_hideResources = new JCheckBox(Messages.getString("uk.ac.reload.editor.prefs.CP_PrefsPanel.0"));
        this.add(this._checkbox_hideResources, new XYConstraints(x, y, 0, 20));
        this._checkbox_hideSCORM = new JCheckBox(Messages.getString("uk.ac.reload.editor.prefs.CP_PrefsPanel.1"));
        this.add(this._checkbox_hideSCORM, new XYConstraints(x, y += 20, 0, 20));
        x = 10;
        JLabel label = new JLabel(Messages.getString("uk.ac.reload.editor.prefs.CP_PrefsPanel.2"));
        this.add(label, new XYConstraints(x, (y += 30) + 2, 0, 0));
        this._profileCPCombobox = new DweezilComboBox(false);
        this.add((Component)this._profileCPCombobox, new XYConstraints(x += 230, y, 200, 22));
        x = 10;
        label = new JLabel(Messages.getString("uk.ac.reload.editor.prefs.CP_PrefsPanel.3"));
        this.add(label, new XYConstraints(x, (y += 30) + 2, 0, 0));
        this._profileSCORMCombobox = new DweezilComboBox(false);
        this.add((Component)this._profileSCORMCombobox, new XYConstraints(x += 230, y, 200, 22));
        y += 20;
    }

    public void saveToUserPrefs(UserPrefs prefs) {
        String scorm_profile;
        prefs.putBooleanValue("hide_resources", this._checkbox_hideResources.isSelected());
        prefs.putBooleanValue("hide_scorm", this._checkbox_hideSCORM.isSelected());
        String cp_profile = (String)this._profileCPCombobox.getSelectedItem();
        if (cp_profile != null) {
            prefs.putValue("default_cp_profile", cp_profile);
        }
        if ((scorm_profile = (String)this._profileSCORMCombobox.getSelectedItem()) != null) {
            prefs.putValue("default_scorm_profile", scorm_profile);
        }
    }

    public void setFields(UserPrefs prefs) {
        this._checkbox_hideResources.setSelected(prefs.getBooleanValue("hide_resources"));
        this._checkbox_hideSCORM.setSelected(prefs.getBooleanValue("hide_scorm"));
        Object[] cp_profiles = HelperProfile.getHelperProfileNames((File)CP_EditorHandler.PROFILE_FOLDER);
        this._profileCPCombobox.setItems(cp_profiles);
        String profile = prefs.getValue("default_cp_profile");
        if (profile != null) {
            this._profileCPCombobox.setSelectedItem((Object)profile);
        }
        Object[] scorm_profiles = HelperProfile.getHelperProfileNames((File)SCORM12_EditorHandler.PROFILE_FOLDER);
        this._profileSCORMCombobox.setItems(scorm_profiles);
        profile = prefs.getValue("default_scorm_profile");
        if (profile != null) {
            this._profileSCORMCombobox.setSelectedItem((Object)profile);
        }
    }

    public void cancel() {
    }
}

