/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.tableview;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.treetable.DweezilTreeTable;
import uk.ac.reload.dweezil.gui.treetable.DweezilTreeTablePopupHandler;
import uk.ac.reload.dweezil.gui.treetable.JTreeTable;
import uk.ac.reload.dweezil.gui.treetable.TreeTableModel;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.ElementInfoPanel;
import uk.ac.reload.editor.gui.TreeIconInterface;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TreeNode;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TreeRenderer;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TreeTableModel;
import uk.ac.reload.editor.metadata.xml.Metadata;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentClipboard;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class MD_TreeTable
extends DweezilTreeTable
implements TreeSelectionListener,
XMLDocumentListener {
    private ElementInfoPanel _infoPanel;
    private DweezilTreeTablePopupHandler _popupMenuHandler;
    private Metadata _metadata;
    private SchemaController _schemaController;
    private Menu_Edit _editMenu;
    private TreePath _currentTreePath;
    private ProxyDeleteHandler _deleteHandler;
    private ProxyCutHandler _cutHandler;
    private ProxyCopyHandler _copyHandler;
    private ProxyPasteHandler _pasteHandler;
    private ProxyMoveUpHandler _moveUpHandler;
    private ProxyMoveDownHandler _moveDownHandler;

    public MD_TreeTable(MD_TreeTableModel treeTableModel, ElementInfoPanel infoPanel, Menu_Edit editMenu) {
        super((TreeTableModel)treeTableModel);
        this._infoPanel = infoPanel;
        this._metadata = treeTableModel.getMetadata();
        this._metadata.addXMLDocumentListener(this);
        this._schemaController = this._metadata.getSchemaController();
        this.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(300);
        tcm.getColumn(2).setPreferredWidth(80);
        this.setShowVerticalLines(true);
        this.setSelectionMode(0);
        this.getTree().setCellRenderer(new MD_TreeRenderer());
        this.getTree().addTreeSelectionListener(this);
        this._popupMenuHandler = new DweezilTreeTablePopupHandler((JTreeTable)this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    MD_TreeTable.this.updateMenus();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    MD_TreeTable.this.clearMenus();
                }
            }
        });
        this._editMenu = editMenu;
        this._editMenu.remapKeyStrokes((JComponent)((Object)this));
        this._cutHandler = new ProxyCutHandler(this._editMenu.actionCut);
        this._copyHandler = new ProxyCopyHandler(this._editMenu.actionCopy);
        this._pasteHandler = new ProxyPasteHandler(this._editMenu.actionPaste);
        this._deleteHandler = new ProxyDeleteHandler(this._editMenu.actionDelete);
        this._moveUpHandler = new ProxyMoveUpHandler(this._editMenu.actionMoveUp);
        this._moveDownHandler = new ProxyMoveDownHandler(this._editMenu.actionMoveDown);
    }

    public void cleanup() {
        this._metadata.removeXMLDocumentListener(this);
        this.clearMenus();
    }

    public void refresh() {
        this.updateInfoPanel(this.getTree().getSelectionPath());
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = event.getPath();
        if (selPath != this._currentTreePath) {
            this.updateMenus(selPath);
            this.updateInfoPanel(selPath);
            this._currentTreePath = selPath;
        }
    }

    protected synchronized void updateInfoPanel(TreePath selPath) {
        if (this._infoPanel != null) {
            if (selPath == null) {
                this._infoPanel.clear();
                return;
            }
            Object selectedNode = selPath.getLastPathComponent();
            if (selectedNode instanceof MD_TreeNode) {
                MD_TreeNode treeNode = (MD_TreeNode)((Object)selectedNode);
                ElementBinding eb = treeNode.createElementBinding();
                this._infoPanel.setElementBinding(eb);
            }
        }
    }

    public void updateMenus() {
        this.updateMenus(this.getTree().getSelectionPath());
    }

    private synchronized void updateMenus(TreePath selPath) {
        this.clearMenus();
        if (selPath == null) {
            return;
        }
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof MD_TreeNode) {
            MD_TreeNode treeNode = (MD_TreeNode)((Object)selectedNode);
            Element element = treeNode.getElement();
            SchemaElement schemaElement = treeNode.getSchemaElement();
            JPopupMenu popupMenu = this._popupMenuHandler.getPopupMenu();
            this._cutHandler.update(element);
            popupMenu.add((Action)this._cutHandler.getMenuAction());
            this._copyHandler.update(element);
            popupMenu.add((Action)this._copyHandler.getMenuAction());
            this._pasteHandler.update(element);
            popupMenu.add((Action)this._pasteHandler.getMenuAction());
            this._deleteHandler.update(element);
            popupMenu.add((Action)this._deleteHandler.getMenuAction());
            popupMenu.addSeparator();
            this._moveUpHandler.update(element);
            popupMenu.add((Action)this._moveUpHandler.getMenuAction());
            this._moveDownHandler.update(element);
            popupMenu.add((Action)this._moveDownHandler.getMenuAction());
            if (schemaElement != null && schemaElement.hasChildren()) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                popupMenu.addSeparator();
                SchemaElement[] children = schemaElement.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    SchemaElement childSchemaElement = children[i];
                    if (!((MD_TreeTableModel)this.getTreeTableModel()).canAddNode(childSchemaElement)) continue;
                    Action_AddChildElement actionAddElement = new Action_AddChildElement(element, childSchemaElement);
                    popupMenu.add(actionAddElement);
                    this._editMenu.addAdditionalItem(actionAddElement);
                }
            }
        }
    }

    public synchronized void clearMenus() {
        JPopupMenu popupMenu = new JPopupMenu();
        this._popupMenuHandler.setPopupMenu(popupMenu);
        this._editMenu.removeAdditionalItems();
        if (this._cutHandler != null) {
            this._cutHandler.clear();
        }
        if (this._copyHandler != null) {
            this._copyHandler.clear();
        }
        if (this._pasteHandler != null) {
            this._pasteHandler.clear();
        }
        if (this._deleteHandler != null) {
            this._deleteHandler.clear();
        }
        if (this._moveUpHandler != null) {
            this._moveUpHandler.clear();
        }
        if (this._moveDownHandler != null) {
            this._moveDownHandler.clear();
        }
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
        MD_TreeNode newNode;
        Element element = event.getElement();
        Element parent = element.getParent();
        DefaultMutableTreeNode parentNode = this.getNode(parent);
        if (parentNode != null && (newNode = this.addNode(parentNode, element)) != null && event.doSelect()) {
            this.selectNode((DefaultMutableTreeNode)((Object)newNode));
        }
    }

    private MD_TreeNode addNode(DefaultMutableTreeNode parentNode, Element element) {
        MD_TreeNode newNode = null;
        int index = this.getInsertNodePosition(parentNode, element);
        if (index != -1) {
            newNode = new MD_TreeNode(element);
            ((DefaultTreeModel)this.getTreeTableModel()).insertNodeInto((MutableTreeNode)((Object)newNode), parentNode, index);
            Iterator it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                this.addNode((DefaultMutableTreeNode)((Object)newNode), child);
            }
        }
        return newNode;
    }

    protected int getInsertNodePosition(DefaultMutableTreeNode parentNode, Element element) {
        Element child;
        if (!((MD_TreeTableModel)this.getTreeTableModel()).doShowNode(element)) {
            return -1;
        }
        int index = 0;
        List children = element.getParent().getChildren();
        for (int i = 0; i < children.size() && (child = (Element)children.get(i)) != element; ++i) {
            if (!((MD_TreeTableModel)this.getTreeTableModel()).doShowNode(child)) continue;
            ++index;
        }
        if (index > parentNode.getChildCount()) {
            index = parentNode.getChildCount();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public void elementRemoved(XMLDocumentListenerEvent event) {
        Element element = event.getElement();
        DefaultMutableTreeNode nodeToDelete = this.getNode(element);
        if (nodeToDelete != null) {
            if (nodeToDelete.isNodeDescendant(this.getSelectedNode())) {
                DefaultMutableTreeNode prevNode = nodeToDelete.getPreviousSibling();
                if (prevNode == null) {
                    prevNode = (DefaultMutableTreeNode)nodeToDelete.getParent();
                }
                ((DefaultTreeModel)this.getTreeTableModel()).removeNodeFromParent(nodeToDelete);
                this.selectNode(prevNode);
            } else {
                ((DefaultTreeModel)this.getTreeTableModel()).removeNodeFromParent(nodeToDelete);
                this.updateMenus(this.getTree().getSelectionPath());
            }
        }
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        final DefaultMutableTreeNode node = this.getNode(event.getElement());
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((DefaultTreeModel)MD_TreeTable.this.getTreeTableModel()).nodeChanged(node);
                }
            });
        }
    }

    public void documentSaved(XMLDocument doc) {
    }

    class ProxyPasteHandler
    extends ProxyAction {
        Element element;

        public ProxyPasteHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (MD_TreeTable.this._metadata.canPasteFromClipboard(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (MD_TreeTable.this._metadata.canPasteFromClipboard(this.element)) {
                Element clipBoardElement = XMLDocumentClipboard.getElement();
                MD_TreeTable.this._metadata.pasteElementUndoable(MD_TreeTable.this, clipBoardElement, this.element, false);
                MD_TreeTable.this.updateMenus(MD_TreeTable.this.getTree().getSelectionPath());
            }
        }
    }

    class ProxyCopyHandler
    extends ProxyAction {
        Element element;

        public ProxyCopyHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (MD_TreeTable.this._metadata.canCopyElement(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            XMLDocumentClipboard.addCopiedElement((Element)this.element);
            MD_TreeTable.this.updateMenus(MD_TreeTable.this.getTree().getSelectionPath());
        }
    }

    class ProxyCutHandler
    extends ProxyAction {
        Element element;

        public ProxyCutHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (MD_TreeTable.this._metadata.canCutElement(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            MD_TreeTable.this._metadata.cutElementUndoable(MD_TreeTable.this, this.element);
            XMLDocumentClipboard.addCutElement((Element)this.element);
        }
    }

    class ProxyDeleteHandler
    extends ProxyAction {
        Element element;

        public ProxyDeleteHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (MD_TreeTable.this._metadata.canDeleteElement(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            MD_TreeTable.this._metadata.deleteElementUndoable(MD_TreeTable.this, this.element);
        }
    }

    class ProxyMoveDownHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveDownHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (MD_TreeTable.this._metadata.canMoveElementDown(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            MD_TreeTable.this._metadata.moveElementDown(MD_TreeTable.this, this.element, true);
        }
    }

    class ProxyMoveUpHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveUpHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (MD_TreeTable.this._metadata.canMoveElementUp(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            MD_TreeTable.this._metadata.moveElementUp(MD_TreeTable.this, this.element, true);
        }
    }

    class Action_AddChildElement
    extends AbstractAction {
        Element parentElement;
        SchemaElement childSchemaElement;
        String name;

        public Action_AddChildElement(Element parentElement, SchemaElement childSchemaElement) {
            this.parentElement = parentElement;
            this.childSchemaElement = childSchemaElement;
            this.name = MD_TreeTable.this._schemaController.getElementFriendlyName(childSchemaElement.getXMLPath());
            if (this.name == null) {
                this.name = childSchemaElement.getName();
            }
            this.putValue("Name", Messages.getString("uk.ac.reload.editor.metadata.tableview.MD_TreeTable.0") + " " + this.name);
            this.putValue("SmallIcon", ((TreeIconInterface)MD_TreeTable.this._schemaController).getLeafIcon(childSchemaElement.getName(), childSchemaElement.getNamespace()));
            this.setEnabled(MD_TreeTable.this._metadata.canAddElement(parentElement, childSchemaElement));
        }

        public void actionPerformed(ActionEvent e) {
            MD_TreeTable.this._metadata.addElementBySchemaUndoable(MD_TreeTable.this, this.parentElement, this.childSchemaElement, true);
        }
    }
}

