/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.resources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.CoolBarPanel;
import uk.ac.reload.dweezil.gui.CoolBarPanelGroup;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourcesPanel;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.editor.resources.LD_ResourcesEditorPanel;

public class LD_ResourcesPanel
extends GradientPanel
implements ILD_DataModelHandler,
TreeSelectionListener {
    private LD_DataModel _ldDataModel;
    private JSplitPane _splitPane;
    private CP_ResourcesPanel _cpResourcesPanel;
    private LD_ResourcesEditorPanel _editorpanel;

    public LD_ResourcesPanel() {
        super((LayoutManager)new BorderLayout());
        JLabel label = new JLabel("Resources");
        label.setFont(label.getFont().deriveFont(1, 16.0f));
        this.add(label, "North");
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this.add(this._splitPane, "Center");
        this._splitPane.setLeftComponent((Component)((Object)this.getCP_ResourcesPanel()));
        this._splitPane.setRightComponent((Component)((Object)this.getLD_ResourcesEditorPanel()));
        CoolBarPanelGroup coolbarGroup = new CoolBarPanelGroup();
        coolbarGroup.addCoolBarPanel((CoolBarPanel)this.getCP_ResourcesPanel());
        coolbarGroup.addCoolBarPanel((CoolBarPanel)this.getLD_ResourcesEditorPanel().getResourcesTreePanel());
        this.getLD_ResourcesEditorPanel().getResourcesTreePanel().getTree().addTreeSelectionListener(this);
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        this.getCP_ResourcesPanel().setFileView(ldDataModel.getLearningDesign().getProjectFolder());
        this.getLD_ResourcesEditorPanel().setDataModel(ldDataModel);
    }

    protected void setupView() {
        super.setupView();
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        this.setBorder(border);
    }

    public void initView() {
        this._splitPane.setDividerLocation(0.33);
        this.getCP_ResourcesPanel().setSelected(true);
    }

    public void cleanup() {
        if (this._cpResourcesPanel != null) {
            this._cpResourcesPanel.cleanup();
        }
        if (this._editorpanel != null) {
            this._editorpanel.cleanup();
        }
        this._ldDataModel = null;
    }

    public boolean doSave() {
        return true;
    }

    public CP_ResourcesPanel getCP_ResourcesPanel() {
        if (this._cpResourcesPanel == null) {
            this._cpResourcesPanel = new CP_ResourcesPanel();
        }
        return this._cpResourcesPanel;
    }

    public LD_ResourcesEditorPanel getLD_ResourcesEditorPanel() {
        if (this._editorpanel == null) {
            this._editorpanel = new LD_ResourcesEditorPanel();
        }
        return this._editorpanel;
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object obj;
        if (!e.isAddedPath()) {
            return;
        }
        TreePath selPath = e.getPath();
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof DweezilTreeNode && (obj = ((DweezilTreeNode)selectedNode).getUserObject()) instanceof LD_Component) {
            this.getLD_ResourcesEditorPanel().getResourceEditor().setComponent((LD_Component)obj);
        }
    }
}

