/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.method;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.learningdesign.datamodel.method.Method;
import uk.ac.reload.editor.learningdesign.editor.method.MethodPlayListPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.CompletionPanel;

public class MethodCompletionPanel
extends CompletionPanel {
    static final String TITLE = "Method Completion";
    static final String DESCRIPTION = "Information relating to the completion of this Method.";
    private static String[] radioText = new String[]{"None", "Time Limit", "When Plays Completed", "When a property is set"};
    private MethodPlayListPanel _listPanel;

    protected MethodCompletionPanel(boolean isVisible) {
        super(isVisible);
        this.getHiderLabelPanel().getTitleLabel().setText("<html>Method Completion");
        this.getHiderLabelPanel().getDescriptionLabel().setText("<html>Information relating to the completion of this Method.");
    }

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        Method method = (Method)dataComponent;
        this.getCompletionFeedbackPanel().setItemModelType(method.getFeedbackDescriptionItemModelType());
        DataElement timeLimit = method.getTimeLimitDataElement();
        DataElement whenPlayCompleted = method.getWhenPlayCompletedDataElement();
        DataElement propertyValue = method.getWhenPropertyValueSetDataElement();
        if (timeLimit.getElement() != null) {
            this.selectRadioButton(1);
            this.getTimeLimitField().setElement(timeLimit);
            this.getPlayListPanel().clear();
        } else if (whenPlayCompleted.getElement() != null) {
            this.selectRadioButton(2);
            this.getTimeLimitField().clear();
            this.getPlayListPanel().setMethod(method);
        } else if (propertyValue.getElement() != null) {
            this.selectRadioButton(3);
            this.getTimeLimitField().clear();
            this.getPlayListPanel().clear();
        } else {
            this.selectRadioButton(0);
            this.getTimeLimitField().clear();
            this.getPlayListPanel().clear();
        }
    }

    protected void radioButtonPressed(int button) {
        Method method = (Method)this.getComponent();
        DataElement completeUnitOfLearning = method.getCompleteUnitOfLearningDataElement();
        completeUnitOfLearning.deleteElement();
        switch (button) {
            case 0: {
                this.getTimeLimitField().clear();
                this.getPlayListPanel().clear();
                break;
            }
            case 1: {
                DataElement timeLimit = method.getTimeLimitDataElement();
                this.getTimeLimitField().setElement(timeLimit);
                this.getPlayListPanel().clear();
                break;
            }
            case 2: {
                this.getTimeLimitField().clear();
                this.getPlayListPanel().setMethod(method);
                break;
            }
            case 3: {
                DataElement propertyValue = method.getWhenPropertyValueSetDataElement();
                this.getTimeLimitField().clear();
                this.getPlayListPanel().clear();
            }
        }
    }

    protected void setupView(boolean isHidden) {
        super.setupView(isHidden);
        this.getRadioButtons()[3].setEnabled(false);
        JButton button = new JButton("Define");
        button.setEnabled(false);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBackground(new Color(250, 250, 254));
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.getCenterPanel().add((Component)buttonPanel, "Center");
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.anchor = 17;
        gc.fill = 2;
        buttonPanel.add((Component)this.getRadioButtons()[0], gc);
        gc.gridy = 1;
        buttonPanel.add((Component)this.getRadioButtons()[1], gc);
        gc.gridx = 1;
        gc.weightx = 2.0;
        buttonPanel.add((Component)this.getTimeLimitField(), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.anchor = 18;
        buttonPanel.add((Component)this.getRadioButtons()[2], gc);
        gc.gridx = 1;
        gc.insets.top = 5;
        gc.anchor = 17;
        buttonPanel.add((Component)((Object)this.getPlayListPanel()), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        buttonPanel.add((Component)this.getRadioButtons()[3], gc);
        gc.gridx = 1;
        gc.fill = 0;
        buttonPanel.add((Component)button, gc);
    }

    protected MethodPlayListPanel getPlayListPanel() {
        if (this._listPanel == null) {
            this._listPanel = new MethodPlayListPanel();
        }
        return this._listPanel;
    }

    protected int getNumberRadioButtons() {
        return radioText.length;
    }

    protected String getRadioButtonText(int button) {
        return radioText[button];
    }

    public void cleanup() {
        if (this._listPanel != null) {
            this._listPanel.cleanup();
        }
        super.cleanup();
    }
}

