/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import uk.ac.reload.dweezil.gui.ShortcutIcon;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.PopupMenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.gui.Editor_Tree;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.EnvironmentRef;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.EnvironmentRef_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environments_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service_Grouping;
import uk.ac.reload.editor.learningdesign.editor.environment.EnvironmentTree;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_TreePanel;

public class EnvironmentTreePanel
extends LD_TreePanel {
    private EnvironmentTree _tree;
    private MenuAction_Add _menuAdd;
    private LD_TreePanel.MenuAction_Delete _menuDelete;
    private LD_TreePanel.MenuAction_Rename _menuRename;
    private LD_TreePanel.MenuAction_MoveUp _menuMoveUp;
    private LD_TreePanel.MenuAction_MoveDown _menuMoveDown;

    public EnvironmentTreePanel() {
        this.setText("Environments");
        this.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environments.gif"));
        this._menuAdd = new MenuAction_Add();
        this.addMenuActionToCoolBar((MenuAction)this._menuAdd);
        this._menuDelete = new LD_TreePanel.MenuAction_Delete(this);
        this.addMenuActionToCoolBar(this._menuDelete);
        this._menuMoveUp = new LD_TreePanel.MenuAction_MoveUp(this);
        this.addMenuActionToCoolBar(this._menuMoveUp);
        this._menuMoveDown = new LD_TreePanel.MenuAction_MoveDown(this);
        this.addMenuActionToCoolBar(this._menuMoveDown);
        this._menuRename = new LD_TreePanel.MenuAction_Rename(this);
    }

    public Editor_Tree getTree() {
        if (this._tree == null) {
            this._tree = new EnvironmentTree();
        }
        return this._tree;
    }

    public synchronized void updateMenus() {
        super.updateMenus();
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        this._menuAdd.newEnvironment.setEnabled(component instanceof Environments_Grouping);
        this._menuAdd.newLO.setEnabled(component instanceof LearningObject_Grouping);
        this._menuAdd.newSendMail.setEnabled(component instanceof Service_Grouping);
        this._menuAdd.newConference.setEnabled(component instanceof Service_Grouping);
        this._menuAdd.newIndexSearch.setEnabled(component instanceof Service_Grouping);
        if (component instanceof EnvironmentRef_Grouping) {
            Environment env = (Environment)component.getParent();
            Environment[] envs = env.getAllowedEnvironmentsToReference();
            this._menuAdd.newEnvironmentRef.setEnabled(envs.length != 0);
        } else {
            this._menuAdd.newEnvironmentRef.setEnabled(false);
        }
        this._menuDelete.setEnabled(component != null && component.canDelete());
        this._menuRename.setEnabled(component instanceof Environment || component instanceof Service || component instanceof LearningObject);
        this._menuMoveUp.setEnabled(component != null && component.canMoveUp());
        this._menuMoveDown.setEnabled(component != null && component.canMoveDown());
        this.getTree().getPopupMenu().removeAll();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newEnvironment);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newLO);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newSendMail);
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newConference);
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newIndexSearch);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newEnvironmentRef);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)((Object)this._menuDelete));
        this.getTree().getPopupMenu().add((Action)((Object)this._menuRename));
    }

    private void addNewEnvironmentRef(String message, Icon icon) {
        EnvironmentRef envRef;
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        if (!(component instanceof EnvironmentRef_Grouping)) {
            return;
        }
        Environment environment = (Environment)component.getParent();
        Object[] envs = environment.getAllowedEnvironmentsToReference();
        if (envs.length == 0) {
            return;
        }
        Environment env = (Environment)JOptionPane.showInputDialog(EditorFrame.getInstance(), "Environment", message, 3, icon, envs, null);
        if (env != null && (envRef = (EnvironmentRef)this.getTree().addNewElement("environment-ref", null)) != null) {
            envRef.setLD_ComponentRef(env);
        }
    }

    static /* synthetic */ void access$100(EnvironmentTreePanel x0, String x1, Icon x2) {
        x0.addNewEnvironmentRef(x1, x2);
    }

    class MenuAction_Add
    extends PopupMenuAction {
        MenuAction newEnvironment = new MenuAction(this, "New Environment", "uk/ac/reload/editor/resources/images/environment.gif"){
            private final /* synthetic */ MenuAction_Add this$1;
            {
                this.this$1 = this$1;
            }

            public void actionPerformed(ActionEvent e) {
                MenuAction_Add.access$000(this.this$1).addNewElement("New Environment", this.getMenuIcon(), "environment");
            }
        };
        MenuAction newLO;
        MenuAction newSendMail;
        MenuAction newConference;
        MenuAction newIndexSearch;
        MenuAction newEnvironmentRef;

        public MenuAction_Add() {
            super("Add", "uk/ac/reload/editor/resources/images/add.gif");
            this.getPopupMenu().add((Action)this.newEnvironment);
            this.getPopupMenu().addSeparator();
            this.newLO = new MenuAction(this, "New Learning Object", "uk/ac/reload/editor/resources/images/learning_object.gif"){
                private final /* synthetic */ MenuAction_Add this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    MenuAction_Add.access$000(this.this$1).addNewElement("New Learning Object", this.getMenuIcon(), "learning-object");
                }
            };
            this.getPopupMenu().add((Action)this.newLO);
            this.getPopupMenu().addSeparator();
            this.newSendMail = new MenuAction(this, "New Send Mail", "uk/ac/reload/editor/resources/images/sendmail.gif"){
                private final /* synthetic */ MenuAction_Add this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    MenuAction_Add.access$000(this.this$1).addNewElement("New Send Mail", this.getMenuIcon(), "send-mail");
                }
            };
            this.getPopupMenu().add((Action)this.newSendMail);
            this.newConference = new MenuAction(this, "New Conference", "uk/ac/reload/editor/resources/images/conference.gif"){
                private final /* synthetic */ MenuAction_Add this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    MenuAction_Add.access$000(this.this$1).addNewElement("New Conference", this.getMenuIcon(), "conference");
                }
            };
            this.getPopupMenu().add((Action)this.newConference);
            this.newIndexSearch = new MenuAction(this, "New Index Search", "uk/ac/reload/editor/resources/images/index_search.gif"){
                private final /* synthetic */ MenuAction_Add this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    MenuAction_Add.access$000(this.this$1).addNewElement("New Index Search", this.getMenuIcon(), "index-search");
                }
            };
            this.getPopupMenu().add((Action)this.newIndexSearch);
            this.getPopupMenu().addSeparator();
            this.newEnvironmentRef = new MenuAction(this, "New Environment Reference"){
                private final /* synthetic */ MenuAction_Add this$1;
                {
                    this.this$1 = this$1;
                    ImageIcon icon = DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environment.gif");
                    this.setMenuIcon((Icon)new ShortcutIcon((Icon)icon));
                }

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.access$100(MenuAction_Add.access$000(this.this$1), "New Environment Reference", this.getMenuIcon());
                }
            };
            this.getPopupMenu().add((Action)this.newEnvironmentRef);
        }

        static /* synthetic */ EnvironmentTreePanel access$000(MenuAction_Add x0) {
            return x0.EnvironmentTreePanel.this;
        }
    }
}

