/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import java.util.Iterator;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_ComponentRef;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.EnvironmentRef;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environments_Grouping;

public class EnvironmentRef_Grouping
extends LD_Grouping
implements IDataComponentIcon {
    static final String TITLE = "Environment References";
    static final String DESCRIPTION = "Add Environment References to the Learning Design.";

    public EnvironmentRef_Grouping(LD_DataModel ldDataModel, Environment environment) {
        this.setDataModel(ldDataModel);
        this.setElement(environment.getElement());
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.addChildren();
    }

    protected void addChildren() {
        Iterator it = this.getElement().getChildren("environment-ref", this.getElement().getNamespace()).iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            EnvironmentRef ldComponent = new EnvironmentRef(this.getLD_DataModel(), element);
            this.addChild(ldComponent);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"environment-ref".equals(elementName)) {
            return null;
        }
        EnvironmentRef ldComponent = null;
        Element element = this.addChildElement(this.getElement(), elementName);
        if (element != null) {
            ldComponent = new EnvironmentRef(this.getLD_DataModel(), element);
            this.addChild(ldComponent);
            if (title != null) {
                ldComponent.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(ldComponent);
        }
        return ldComponent;
    }

    public boolean hasEnvironmentRef(Environment environment) {
        if (environment == null) {
            return false;
        }
        DataComponent[] env_refs = this.getChildren();
        for (int i = 0; i < env_refs.length; ++i) {
            LD_Component refComponent = ((LD_ComponentRef)env_refs[i]).getLD_ComponentRef();
            if (environment != refComponent) continue;
            return true;
        }
        return false;
    }

    public void updateEnvironmentRefs(Environments_Grouping envGrouping) {
        DataComponent[] env_refs = this.getChildren();
        for (int i = 0; i < env_refs.length; ++i) {
            EnvironmentRef envRef = (EnvironmentRef)env_refs[i];
            LD_Component env = envGrouping.getChildByIdentifer(envRef.getRef());
            if (env == null) continue;
            envRef.setLD_ComponentRef(env);
        }
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environments.gif");
    }
}

