/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.activities;

import java.util.Iterator;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activities_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.LearningActivity;

public class LearningActivity_Grouping
extends LD_Grouping
implements IDataComponentIcon {
    static final String TITLE = "Learning Activities";
    static final String DESCRIPTION = "Add Learning Activities to the Learning Design.";
    private Activities_Grouping _activitiesGrouping;

    public LearningActivity_Grouping(LD_DataModel ldDataModel, Activities_Grouping activitiesGrouping) {
        this.setDataModel(ldDataModel);
        this._activitiesGrouping = activitiesGrouping;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.addChildren();
    }

    protected void addChildren() {
        Element elementActivities = this._activitiesGrouping.getActivitiesElement();
        if (elementActivities != null) {
            this.setElement(elementActivities);
            Iterator it = elementActivities.getChildren("learning-activity", elementActivities.getNamespace()).iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                LearningActivity la = new LearningActivity(this.getLD_DataModel(), child);
                this.addChild(la);
            }
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        Element element;
        if (!"learning-activity".equals(elementName)) {
            return null;
        }
        LearningActivity la = null;
        Element elementActivities = this._activitiesGrouping.getActivitiesElement();
        if (elementActivities == null) {
            elementActivities = this._activitiesGrouping.ensureActivitiesElement();
        }
        if ((element = this.addChildElement(this.getElement(), elementName)) != null) {
            la = new LearningActivity(this.getLD_DataModel(), element);
            this.addChild(la);
            if (title != null) {
                la.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(la);
        }
        return la;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/learning_activities.gif");
    }
}

