/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class TipPanel
extends GradientPanel {
    private JLabel _nameLabel;
    private JLabel _tipLabel;

    public TipPanel() {
        this.setLayout(new BorderLayout());
        this._nameLabel = new JLabel();
        this._nameLabel.setFont(DweezilUIManager.boldFont12);
        this.add(this._nameLabel, "North");
        this._tipLabel = new JLabel();
        this._tipLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this._tipLabel.setVerticalAlignment(1);
        this.add(this._tipLabel, "Center");
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setBorder(border);
    }

    public void clear() {
        this._nameLabel.setText("");
        this._tipLabel.setText("");
    }

    public void setTip(SchemaController schemaController, SchemaElement schemaElement) {
        if (schemaElement != null) {
            XMLPath xmlPath = schemaElement.getXMLPath();
            String fname = schemaController.getElementFriendlyName(xmlPath);
            if (fname == null) {
                fname = schemaElement.getName();
            }
            this._nameLabel.setText(" " + fname);
            String tip = schemaController.getElementTip(xmlPath);
            if (tip == null) {
                this._tipLabel.setText("");
            } else {
                this._tipLabel.setText("<html>" + tip + "</font><br>");
            }
        } else {
            this._nameLabel.setText("");
            this._tipLabel.setText("");
        }
    }
}

