/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.HTMLLabelTextField;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;

public class IdentifierLabelTextField
extends HTMLLabelTextField {
    public static final Color BKG_COLOR = new Color(240, 240, 255);
    private DataElement _dataElement;
    private DataElementTextField _textField;

    public IdentifierLabelTextField() {
        this("");
    }

    public IdentifierLabelTextField(String text) {
        super(text);
    }

    protected void setup() {
        super.setup();
        this.getLabel().setToolTipText("Double-click to edit Identifier");
        this.getLabel().setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setBackground(BKG_COLOR);
    }

    protected void setUI() {
        this.setOpaque(true);
    }

    public void setElement(DataElement datElement) {
        this._dataElement = datElement;
        Element element = this._dataElement.getElement();
        if (element != null) {
            Attribute att = element.getAttribute("identifier");
            if (att != null) {
                this.setText(att.getValue());
            } else {
                this.setText("");
            }
        }
    }

    protected void finishEdit() {
        Element element;
        super.finishEdit();
        if (this._dataElement != null && (element = this._dataElement.getElement()) != null) {
            element.setAttribute("identifier", this.getText());
            this._dataElement.getDataModel().getSchemaDocument().changedElement((Object)this, element);
        }
    }

    public JTextField getTextField() {
        if (this._textField == null) {
            this._textField = new DataElementTextField();
        }
        return this._textField;
    }
}

