/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.moonunit.SchemaDocument;

public class DocumentSourceViewerPanel
extends JPanel
implements XMLDocumentListener {
    private SchemaDocument _doc;
    private JTextArea _textArea;

    public DocumentSourceViewerPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        this._textArea.setLineWrap(true);
        this._textArea.setWrapStyleWord(true);
        this._textArea.setCursor(DweezilUIManager.TEXT_CURSOR);
        this._textArea.setFont(DweezilUIManager.plainFont12);
        this.add((Component)new JScrollPane(this._textArea), "Center");
    }

    public void setDocument(SchemaDocument doc) {
        this._doc = doc;
        this._doc.addXMLDocumentListener((XMLDocumentListener)this);
        this.refreshView();
    }

    public void destroy() {
        this._doc.removeXMLDocumentListener((XMLDocumentListener)this);
    }

    private String getSource(Document document) {
        XMLOutputter outputter = new XMLOutputter("   ", true);
        outputter.setTextNormalize(true);
        return outputter.outputString(document);
    }

    public synchronized void refreshView() {
        Thread thread = new Thread(){

            public void run() {
                Document doc = DocumentSourceViewerPanel.this._doc.getDocument();
                String source = DocumentSourceViewerPanel.this.getSource(doc);
                DocumentSourceViewerPanel.this._textArea.setText(source);
            }
        };
        thread.start();
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
        this.refreshView();
    }

    public void elementRemoved(XMLDocumentListenerEvent event) {
        this.refreshView();
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        this.refreshView();
    }

    public void documentSaved(XMLDocument doc) {
    }
}

