/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.htmlparser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import uk.ac.reload.editor.contentpackaging.htmlparser.CSSParser;
import uk.ac.reload.editor.contentpackaging.htmlparser.FileType;
import uk.ac.reload.editor.properties.EditorProperties;

public class HTMLParser {
    public static HTML.Attribute[] htmlAttributesToParse = new HTML.Attribute[]{HTML.Attribute.HREF, HTML.Attribute.BACKGROUND, HTML.Attribute.SRC, HTML.Attribute.CODE, HTML.Attribute.ACTION};
    private File _htmlFile;
    private boolean _firstPage = true;
    private File _rootFolder;
    private boolean _higherLocalLinkFound;
    private boolean _absoluteLocalLinkFound;
    private Vector _allLinks;

    public HTMLParser(File htmlFile, File rootFolder) {
        this._htmlFile = htmlFile;
        this._rootFolder = rootFolder;
        this._allLinks = new Vector();
        this.parseTheHtml(htmlFile);
    }

    public File[] getAllLinks() {
        Object[] files = new File[this._allLinks.size()];
        this._allLinks.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    public boolean isAbsoluteLocalLinkFound() {
        return this._absoluteLocalLinkFound;
    }

    public boolean isHigherLocalLinkFound() {
        return this._higherLocalLinkFound;
    }

    protected void parseTheHtml(File htmlFile) {
        block4: {
            final String sourcePath = htmlFile.getParent() + File.separatorChar;
            if (htmlFile.getName().toLowerCase().endsWith(".css")) {
                CSSParser aCssFile = new CSSParser(htmlFile);
                String[] theCssLinks = aCssFile.getLinks();
                for (int i = 0; i < theCssLinks.length; ++i) {
                    this.buildTheResource(theCssLinks[i], sourcePath);
                }
                return;
            }
            HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

                public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                    HTMLParser.this.buildTheResource(HTMLParser.this.parseAttributes(tag, attrSet, pos, sourcePath), sourcePath);
                }

                public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                    HTMLParser.this.buildTheResource(HTMLParser.this.parseAttributes(tag, attrSet, pos, sourcePath), sourcePath);
                }
            };
            try {
                FileReader reader = new FileReader(htmlFile);
                new ParserDelegator().parse(reader, callback, true);
            }
            catch (Exception ex) {
                if (!EditorProperties.getString("DEBUG").equals("true")) break block4;
                ex.printStackTrace();
            }
        }
    }

    protected String parseAttributes(HTML.Tag tag, MutableAttributeSet attrSet, int pos, String sourcePath) {
        String returnString = null;
        Enumeration<?> attributes = attrSet.getAttributeNames();
        while (attributes.hasMoreElements()) {
            Object o = attributes.nextElement();
            String attributename = o.toString();
            Iterator listElement = FileType.JAVASCRIPTEVENTS.iterator();
            while (listElement.hasNext()) {
                if (attributename.toLowerCase().compareTo(listElement.next().toString()) != 0) continue;
                String attributevalue = (String)attrSet.getAttribute(o);
                this.dealWithJavascriptEvent(attributevalue, sourcePath);
            }
            for (int attributeArrayIndex = 0; attributeArrayIndex < htmlAttributesToParse.length; ++attributeArrayIndex) {
                String aLink;
                String aLinkLowerCase;
                if (o != htmlAttributesToParse[attributeArrayIndex] || (aLinkLowerCase = (aLink = (String)attrSet.getAttribute(o)).toLowerCase()).startsWith("http:") || aLinkLowerCase.startsWith("https:") || aLinkLowerCase.startsWith("mailto:")) continue;
                if (aLinkLowerCase.startsWith("javascript:") || aLinkLowerCase.startsWith("#")) {
                    this.dealWithJavascriptEvent(aLink, sourcePath);
                    returnString = null;
                    continue;
                }
                if (aLinkLowerCase.startsWith("file:")) {
                    this._absoluteLocalLinkFound = true;
                    returnString = null;
                    continue;
                }
                returnString = aLink;
            }
        }
        return returnString;
    }

    protected void dealWithJavascriptEvent(String aLink, String sourcePath) {
        String[] javascriptBits = aLink.split("'");
        for (int scriptArrayIndex = 0; scriptArrayIndex < javascriptBits.length; ++scriptArrayIndex) {
            Iterator listElement = FileType.ALL_EXTENSIONS.iterator();
            while (listElement.hasNext()) {
                if (!javascriptBits[scriptArrayIndex].toLowerCase().endsWith(listElement.next().toString())) continue;
                this.buildTheResource(javascriptBits[scriptArrayIndex], sourcePath);
            }
        }
    }

    protected void buildTheResource(String localLink, String sourcePath) {
        block9: {
            if (localLink != null) {
                try {
                    File original = new File(URLDecoder.decode(sourcePath + localLink, "UTF-8"));
                    if (!original.exists()) break block9;
                    try {
                        File originalCanonical = new File(original.getCanonicalPath());
                        if (originalCanonical.getAbsolutePath().toLowerCase().startsWith(this._rootFolder.getAbsolutePath().toLowerCase())) {
                            boolean gotit = this._allLinks.contains(originalCanonical);
                            if (!gotit) {
                                if (!originalCanonical.isDirectory()) {
                                    this._allLinks.add(originalCanonical);
                                }
                                Iterator listElement = FileType.EXTENSIONS_TO_PARSE.iterator();
                                while (listElement.hasNext()) {
                                    if (!localLink.toLowerCase().endsWith(listElement.next().toString())) continue;
                                    this._firstPage = false;
                                    this.parseTheHtml(original);
                                }
                            }
                            break block9;
                        }
                        this._higherLocalLinkFound = true;
                    }
                    catch (IOException e) {
                        System.out.println("A problem occured when trying to find all links in " + localLink + " This is probably due to the page having Absolute links to local files on your computer.  Please amend this page\n");
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    System.out.println("Error: Encoding exception in HTML document '" + ex.toString() + "'");
                }
            }
        }
    }
}

