/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.htmlparser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class CSSParser {
    public static char TAB = (char)9;
    public static char CRETURN = (char)13;
    public static char LINEFEED = (char)10;
    public static char END_BRACKET = (char)41;
    public static char SEMI_COLON = (char)59;
    public static char DOUBLE_QUOTE = (char)34;
    public static char SINGLE_QUOTE = (char)39;
    private Vector _linksFound = new Vector();

    public CSSParser(File thefile) {
        this.startit(thefile);
    }

    public String[] getLinks() {
        Object[] resources = new String[this._linksFound.size()];
        this._linksFound.copyInto(resources);
        return resources;
    }

    private void startit(File thefile) {
        try {
            int ainByte;
            StringBuffer buf = new StringBuffer();
            FileReader text = new FileReader(thefile);
            do {
                ainByte = text.read();
                char inByte = (char)ainByte;
                if (ainByte == -1 || inByte == TAB || inByte == CRETURN || inByte == LINEFEED) continue;
                buf.append(inByte);
                if (inByte != END_BRACKET && inByte != SEMI_COLON) continue;
                this.findUrlLink(buf);
            } while (ainByte != -1);
            text.close();
        }
        catch (IOException ex) {
            System.out.println("Error: Error parsing css file: " + ex);
        }
    }

    private void findUrlLink(StringBuffer buf) {
        String astyle = buf.toString();
        int startcount = astyle.indexOf("url(");
        if (startcount != -1) {
            int endcount = astyle.indexOf(END_BRACKET);
            String aLink = astyle.substring(startcount + 4, endcount);
            if (aLink.indexOf(DOUBLE_QUOTE) != -1 || aLink.indexOf(SINGLE_QUOTE) != -1) {
                if (aLink.indexOf(DOUBLE_QUOTE) == 0 || aLink.indexOf(SINGLE_QUOTE) == 0) {
                    String firstCharRemoved;
                    aLink = firstCharRemoved = aLink.substring(1, aLink.length());
                }
                if (aLink.indexOf(DOUBLE_QUOTE) == aLink.length() - 1 || aLink.indexOf(SINGLE_QUOTE) == aLink.length() - 1) {
                    String lastCharRemoved;
                    aLink = lastCharRemoved = aLink.substring(0, aLink.length() - 1);
                }
            }
            if (!(aLink.toLowerCase().startsWith("http:") || aLink.toLowerCase().startsWith("https:") || aLink.toLowerCase().startsWith("mailto:"))) {
                this._linksFound.add(aLink);
            }
            buf.delete(0, buf.length());
        }
    }
}

