/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.resourceview;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.dnd.DNDUtils;
import uk.ac.reload.dweezil.dnd.DragObject;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeDragDropHandler;
import uk.ac.reload.dweezil.gui.tree.DweezilTreePopupHandler;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.datamodel.CP_Resource;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourceImporter;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourcesTreeModel;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourcesTreeNode;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourcesTreeRenderer;
import uk.ac.reload.editor.properties.EditorProperties;

public class CP_ResourcesTree
extends DweezilTree
implements IIcons {
    private CP_ResourcesTreeModel _resourcesTreeModel = new CP_ResourcesTreeModel();
    private CP_ResourcesTreeDragDropHandler _dragdropHandler;
    private DweezilTreePopupHandler _popupMenuHandler;

    public CP_ResourcesTree() {
        this.setModel((TreeModel)((Object)this._resourcesTreeModel));
        this.setCellRenderer(new CP_ResourcesTreeRenderer());
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                CP_ResourcesTreeNode node = (CP_ResourcesTreeNode)((Object)path.getLastPathComponent());
                CP_ResourcesTree.this._resourcesTreeModel.buildChildNodes(node);
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CP_ResourcesTreeNode targetNode;
                TreePath path;
                if (e.getClickCount() == 2 && (path = CP_ResourcesTree.this.getPathForLocation(e.getX(), e.getY())) != null && (targetNode = (CP_ResourcesTreeNode)((Object)path.getLastPathComponent())) != null && targetNode.getCP_Resource().isFile()) {
                    CP_ResourcesTree.this.setCursor(DweezilUIManager.WAIT_CURSOR);
                    NativeLauncher.launchFile((File)targetNode.getCP_Resource());
                    CP_ResourcesTree.this.setCursor(DweezilUIManager.DEFAULT_CURSOR);
                }
            }
        });
        this._dragdropHandler = new CP_ResourcesTreeDragDropHandler(this);
    }

    public void setFileView(File rootFolder) {
        this._resourcesTreeModel.setFileView(rootFolder);
        this.selectNode((DefaultMutableTreeNode)this._resourcesTreeModel.getRootNode());
    }

    public DweezilTreePopupHandler getDweezilTreePopupHandler() {
        if (this._popupMenuHandler == null) {
            this._popupMenuHandler = new DweezilTreePopupHandler((JTree)((Object)this));
        }
        return this._popupMenuHandler;
    }

    public JPopupMenu getPopupMenu() {
        return this.getDweezilTreePopupHandler().getPopupMenu();
    }

    public void refresh() {
        this._resourcesTreeModel.refresh();
        this.selectNode((DefaultMutableTreeNode)this._resourcesTreeModel.getRootNode());
    }

    public CP_Resource[] getSelectedResourcesToDelete() {
        Vector<CP_Resource> v = new Vector<CP_Resource>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                CP_ResourcesTreeNode fileSysEntity = (CP_ResourcesTreeNode)((Object)paths[i].getLastPathComponent());
                if (fileSysEntity.isRoot()) continue;
                CP_Resource aFileToDelete = fileSysEntity.getCP_Resource();
                v.add(aFileToDelete);
            }
        }
        Object[] resources = new CP_Resource[v.size()];
        v.copyInto(resources);
        return resources;
    }

    protected void addFiles(final File[] files, CP_ResourcesTreeNode targetNode) {
        final CP_Resource targetFolder = targetNode.getCP_Resource();
        if (!targetFolder.isDirectory()) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DweezilProgressMonitor progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesTree.0"), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesTree.1"), "", true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
                try {
                    new CP_ResourceImporter(files, targetFolder, false, progressMonitor);
                }
                catch (IOException ex) {
                    if (EditorProperties.getString("DEBUG").equals("true")) {
                        ex.printStackTrace();
                    }
                    ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesTree.2"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesTree.3"), (Exception)ex);
                }
                finally {
                    progressMonitor.close();
                }
                CP_ResourcesTree.this.refresh();
            }
        };
        thread.start();
    }

    class CP_ResourcesTreeDragDropHandler
    extends DweezilTreeDragDropHandler {
        public CP_ResourcesTreeDragDropHandler(DweezilTree tree) {
            super(tree);
        }

        public void dragGestureRecognized(DragGestureEvent event) {
            if ((event.getDragAction() & 3) == 0) {
                return;
            }
            TreePath[] paths = CP_ResourcesTree.this.getSelectionPaths();
            if (paths != null) {
                Vector<CP_Resource> v = new Vector<CP_Resource>();
                for (int i = 0; i < paths.length; ++i) {
                    CP_ResourcesTreeNode node = (CP_ResourcesTreeNode)((Object)paths[i].getLastPathComponent());
                    v.add(node.getCP_Resource());
                }
                if (!v.isEmpty()) {
                    Object[] resources = new CP_Resource[v.size()];
                    v.copyInto(resources);
                    DragObject dragObject = new DragObject((Serializable)resources, (JComponent)((Object)CP_ResourcesTree.this));
                    Point ptDragOrigin = event.getDragOrigin();
                    TreePath path = CP_ResourcesTree.this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
                    if (path == null) {
                        return;
                    }
                    BufferedImage imgGhost = this.getDragImage(path, ptDragOrigin);
                    event.startDrag(DragSource.DefaultCopyNoDrop, imgGhost, new Point(5, 5), (Transferable)dragObject, (DragSourceListener)((Object)this));
                }
            }
        }

        public boolean isDropOK(DropTargetDragEvent event) {
            CP_ResourcesTreeNode targetNode = (CP_ResourcesTreeNode)((Object)this.getDragOverTreeNode(event));
            if (targetNode == null) {
                return false;
            }
            CP_Resource file = targetNode.getCP_Resource();
            if (!file.isDirectory()) {
                return false;
            }
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent event) {
            Point location = event.getLocation();
            TreePath treePath = CP_ResourcesTree.this.getPathForLocation(location.x, location.y);
            if (treePath == null) {
                return;
            }
            CP_ResourcesTreeNode targetNode = (CP_ResourcesTreeNode)((Object)treePath.getLastPathComponent());
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(DNDUtils.getCorrectDropContext((DropTargetDropEvent)event));
                try {
                    Object userObject = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof AbstractList) {
                        AbstractList list = (AbstractList)userObject;
                        Object[] files = list.toArray();
                        CP_ResourcesTree.this.addFiles((File[])files, targetNode);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.hiliteNode(this._prevHilitedNode, false);
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
    }
}

