/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uk.ac.reload.diva.util.FileUtils;

public class CopyTask {
    private File target;
    private ZipEntry zipEntry;
    private InputStream in;
    private FileOutputStream out;
    private byte[] data;
    private int len;
    private boolean exists;
    private File destinationFolder;
    private URL resourceUrl;

    public CopyTask(String resource, File destinationFolder) throws IOException {
        this.destinationFolder = destinationFolder;
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.resourceUrl = classLoader.getResource(resource);
        if (this.resourceUrl == null) {
            throw new IOException("Resource not found: " + resource);
        }
    }

    public void backup() throws IOException {
        if (!this.destinationFolder.exists()) {
            return;
        }
        StringBuffer backupName = new StringBuffer(this.destinationFolder.getName());
        backupName.append('~');
        File parentFile = this.destinationFolder.getParentFile();
        File backupFile = new File(parentFile, backupName.toString());
        while (backupFile.exists()) {
            backupName.append('~');
            backupFile = new File(parentFile, backupName.toString());
        }
        FileUtils.copyFolder(this.destinationFolder, backupFile);
    }

    public void execute(boolean overwrite) throws IOException {
        String file = this.resourceUrl.getFile();
        int start = file.indexOf(58) + 1;
        int end = file.lastIndexOf(33);
        File supportJar = new File(file.substring(start, end == -1 ? file.length() : end).replaceAll("%20", " "));
        ZipFile zipFile = new ZipFile(supportJar, 1);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            this.zipEntry = e.nextElement();
            this.target = new File(this.destinationFolder, this.zipEntry.getName());
            this.exists = this.target.exists();
            if (this.zipEntry.getSize() == 0L) {
                if (this.target.mkdirs() || !this.target.isFile()) continue;
                StringBuffer newName = new StringBuffer(this.target.getName());
                newName.append('~');
                File parentFile = this.target.getParentFile();
                File newTarget = new File(parentFile, newName.toString());
                while (newTarget.exists()) {
                    newName.append('~');
                    newTarget = new File(parentFile, newName.toString());
                }
                this.target.renameTo(newTarget);
                continue;
            }
            File parentFile = this.target.getParentFile();
            parentFile.mkdirs();
            if (overwrite && this.exists) {
                this.target.delete();
                this.exists = false;
            }
            if (this.exists) continue;
            this.in = zipFile.getInputStream(this.zipEntry);
            this.out = new FileOutputStream(this.target);
            this.data = new byte[10240];
            while (true) {
                this.len = this.in.read(this.data);
                if (this.len < 1) break;
                this.out.write(this.data, 0, this.len);
            }
            this.in.close();
            this.out.close();
        }
    }
}

