/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.formview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.editor.metadata.editor.formview.MD_Field;
import uk.ac.reload.editor.metadata.editor.formview.MD_FormModel;
import uk.ac.reload.editor.metadata.editor.formview.MD_ProfileElement;
import uk.ac.reload.editor.metadata.xml.Metadata;

public class MD_FormPanel
extends GradientPanel
implements Scrollable {
    private MD_FormModel _mdFormModel;
    private Vector _fields = new Vector();

    public MD_FormPanel() {
        this.setLayout(new FlowLayout(0));
        this._mdFormModel = new MD_FormModel();
        this.setBackground(new Color(250, 250, 250));
    }

    public void setDocument(Metadata metadata) {
        this.cleanup();
        this.removeAll();
        this._mdFormModel.setDocument(metadata);
        final MD_ProfileElement rootElement = this._mdFormModel.getRootElement();
        Thread thread = new Thread(){

            public void run() {
                MD_FormPanel.this.add(new GroupPanel(rootElement));
                MD_FormPanel.this.revalidate();
            }
        };
        thread.start();
    }

    public void refresh() {
        if (this._mdFormModel.getDocument() != null) {
            this.setDocument(this._mdFormModel.getDocument());
        }
    }

    public void cleanup() {
        for (int i = 0; i < this._fields.size(); ++i) {
            MD_Field mdField = (MD_Field)this._fields.get(i);
            mdField.cleanup();
        }
        this._fields.clear();
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    class GroupPanel
    extends JPanel {
        protected GridBagConstraints constraints;
        int INDENT = 15;

        public GroupPanel(MD_ProfileElement profileElement) {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.constraints = new GridBagConstraints();
            this.constraints.insets = new Insets(0, this.INDENT, 5, 0);
            this.constraints.gridx = 0;
            this.constraints.gridy = 0;
            this.constraints.weightx = 1.0;
            this.constraints.weighty = 0.0;
            this.constraints.fill = 2;
            this.constraints.anchor = 17;
            if (profileElement.getName() != null) {
                this.addGroupLabel(profileElement.getName());
            }
            MD_ProfileElement[] children = profileElement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                MD_ProfileElement child = children[i];
                if (child.isGroup()) {
                    this.constraints.gridx = 0;
                    this.constraints.gridwidth = 2;
                    this.constraints.weightx = 1.0;
                    this.constraints.fill = 2;
                    this.add((Component)new GroupPanel(child), this.constraints);
                    ++this.constraints.gridy;
                    continue;
                }
                this.addField(child);
            }
        }

        protected void addField(MD_ProfileElement profileElement) {
            this.constraints.fill = 0;
            JLabel l = new JLabel(profileElement.getName());
            l.setBorder(new EmptyBorder(0, this.INDENT, 0, 0));
            this.constraints.gridx = 0;
            this.constraints.gridwidth = 1;
            this.constraints.weightx = 0.0;
            this.add((Component)l, this.constraints);
            MD_Field mdField = MD_FormPanel.this._mdFormModel.createWidget(profileElement);
            if (mdField != null) {
                MD_FormPanel.this._fields.add(mdField);
            }
            this.constraints.gridx = 1;
            if (mdField != null) {
                this.add(mdField.getComponent(), this.constraints);
            }
            ++this.constraints.gridy;
        }

        protected void addGroupLabel(String name) {
            this.constraints.fill = 2;
            this.constraints.gridwidth = 2;
            this.constraints.gridx = 0;
            JLabel label = new JLabel(name);
            label.setOpaque(true);
            label.setBackground(Color.lightGray);
            label.setForeground(Color.black);
            label.setBorder(new EmptyBorder(0, 3, 0, 0));
            this.add((Component)label, this.constraints);
            ++this.constraints.gridy;
        }
    }
}

