/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import javax.swing.AbstractListModel;
import javax.swing.JOptionPane;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.editor.environment.IndexElementSelectorDialog;
import uk.ac.reload.editor.learningdesign.editor.environment.IndexSearchListPanel;

public class IndexElementListPanel
extends IndexSearchListPanel {
    private IndexElementSelectorDialog _dialog;

    public IndexElementListPanel() {
        super("Index Element", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/index_search.gif"), 100);
    }

    protected void updateListModel() {
        LD_Component[] components = this.getIndexSearch().getIndexElements();
        this.getList().setModel(new ComponentListModel(components));
    }

    protected void showSelectorDialog() {
        if (this._dialog == null) {
            this._dialog = new IndexElementSelectorDialog();
        }
        this._dialog.setIndexSearch(this.getIndexSearch());
        this._dialog.show();
    }

    protected void deleteListItems() {
        Object[] components = this.getList().getSelectedValues();
        if (components.length == 0) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this.getParent(), "Are you sure you want to delete the reference(s)?", "Confirm Delete", 0);
        if (result != 0) {
            return;
        }
        int pos = this.getList().getSelectedIndex() - 1;
        for (int i = 0; i < components.length; ++i) {
            this.getIndexSearch().removeIndexElement((LD_Component)components[i]);
        }
        if (pos == -1 && this.getList().getModel().getSize() > 0) {
            pos = 0;
        }
        this.getList().setSelectedIndex(pos);
    }

    public void cleanup() {
        super.cleanup();
        if (this._dialog != null) {
            this._dialog.cleanup();
        }
    }

    protected class ComponentListModel
    extends AbstractListModel {
        private LD_Component[] _components;

        public ComponentListModel(LD_Component[] components) {
            this._components = components;
        }

        public int getSize() {
            return this._components.length;
        }

        public Object getElementAt(int index) {
            return this._components[index];
        }
    }
}

