/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.activities;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.RelativeLayoutManager;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.IdentifierLabelTextField;
import uk.ac.reload.editor.gui.TitledEditorPanel;
import uk.ac.reload.editor.gui.widgets.DataElementComboBox;
import uk.ac.reload.editor.gui.widgets.DataElementNumberField;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.ActivityStructure;
import uk.ac.reload.editor.learningdesign.editor.activities.ActivityEnvironmentsListPanel;
import uk.ac.reload.editor.learningdesign.editor.activities.ActivityStructureListPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.ItemModelTypePanel;
import uk.ac.reload.editor.learningdesign.editor.shared.MetadataPanel;

public class ActivityStructureEditorPanel
extends TitledEditorPanel {
    static final boolean SHOW_IDENTIFIER = false;
    private IdentifierLabelTextField _tfIdentifier;
    private DataElementNumberField _tfNumber;
    private DataElementComboBox _cbSort;
    private DataElementComboBox _cbStructureType;
    private ItemModelTypePanel _infoPanel;
    protected ActivityEnvironmentsListPanel _envListPanel;
    private ActivityStructureListPanel _activityListPanel;
    private MetadataPanel _metadataPanel;

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        ActivityStructure as = (ActivityStructure)dataComponent;
        this.getTitleLabel().setComponent(dataComponent);
        DataElement activityElement = dataComponent.getDataElement();
        this._tfNumber.setAttribute(activityElement, "number-to-select", null);
        this._cbSort.setAttribute(activityElement, "sort", null);
        this._cbStructureType.setAttribute(activityElement, "structure-type", null);
        this._infoPanel.setItemModelType(as.getInformationItemModelType());
        this._envListPanel.setActivity(as);
        this._activityListPanel.setActivity(as);
        this._metadataPanel.setMetadataType(as.getMetadataType());
    }

    protected void setupView() {
        super.setupView();
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        SGLayout fieldPanelLayout = new SGLayout(3, 1, 0, 5);
        JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
        fieldPanel.setOpaque(false);
        layoutManager.addFromLeftToRightEdges((JComponent)fieldPanel, "fieldPanel", "TitledEditorPanel.TOPPANEL_ID", 1, 10, 10);
        this._tfNumber = new DataElementNumberField();
        LabelComponentPanel panelNumber = new LabelComponentPanel("Number to select:", (JComponent)this._tfNumber, 0.3, 5.0);
        fieldPanel.add((Component)panelNumber);
        this._cbSort = new DataElementComboBox(new String[]{"", "as-is", "visibility-order"});
        LabelComponentPanel panelSort = new LabelComponentPanel("Sort:", (JComponent)((Object)this._cbSort), 0.3, 2.0);
        fieldPanel.add((Component)panelSort);
        this._cbStructureType = new DataElementComboBox(new String[]{"", "sequence", "selection"});
        LabelComponentPanel panelStructureType = new LabelComponentPanel("Structure:", (JComponent)((Object)this._cbStructureType), 0.3, 2.0);
        fieldPanel.add((Component)panelStructureType);
        this._infoPanel = new ItemModelTypePanel(false);
        layoutManager.addFromLeftToRightEdges((JComponent)this._infoPanel, "_infoPanel", "fieldPanel", 1, 15, 10);
        this._envListPanel = this.addEnvironmentListPanel("_infoPanel");
        this._activityListPanel = this.addActivityStructureListPanel("envlistPanel");
        this._metadataPanel = new MetadataPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)this._metadataPanel, "_metadataPanel", "actlistPanel", 1, 20, 10);
    }

    protected ActivityEnvironmentsListPanel addEnvironmentListPanel(String parentAnchor) {
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        ComponentHiderLabelPanel envpicker_hider = new ComponentHiderLabelPanel("Environments", "Add Environments that this Activity Structure references.");
        layoutManager.addFromLeftToRightEdges((JComponent)envpicker_hider, "envpicker_hider", parentAnchor, 1, 15, 10);
        ActivityEnvironmentsListPanel listPanel = new ActivityEnvironmentsListPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)((Object)listPanel), "envlistPanel", "envpicker_hider", 1, 5, 10);
        envpicker_hider.getComponentHiderButton().setComponent((JComponent)((Object)listPanel));
        envpicker_hider.getComponentHiderButton().showComponent(false);
        return listPanel;
    }

    protected ActivityStructureListPanel addActivityStructureListPanel(String parentAnchor) {
        RelativeLayoutManager layoutManager = this.getRelativeLayoutManager();
        ComponentHiderLabelPanel picker_hider = new ComponentHiderLabelPanel("Activities", "Add Activities that this Activity Structure references.");
        layoutManager.addFromLeftToRightEdges((JComponent)picker_hider, "actpicker_hider", parentAnchor, 1, 20, 10);
        ActivityStructureListPanel listPanel = new ActivityStructureListPanel();
        layoutManager.addFromLeftToRightEdges((JComponent)((Object)listPanel), "actlistPanel", "actpicker_hider", 1, 5, 10);
        picker_hider.getComponentHiderButton().setComponent((JComponent)((Object)listPanel));
        picker_hider.getComponentHiderButton().showComponent(false);
        return listPanel;
    }

    public void cleanup() {
        super.cleanup();
        if (this._infoPanel != null) {
            this._infoPanel.cleanup();
        }
        if (this._envListPanel != null) {
            this._envListPanel.cleanup();
        }
        if (this._activityListPanel != null) {
            this._activityListPanel.cleanup();
        }
        if (this._metadataPanel != null) {
            this._metadataPanel.cleanup();
        }
    }
}

