/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.activities;

import javax.swing.tree.MutableTreeNode;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataContainer;
import uk.ac.reload.editor.gui.Editor_TreeModel;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activity;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environments_Grouping;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_SelectorTree;

public class ActivityEnvironmentSelectorTree
extends LD_SelectorTree {
    private Activity _activity;

    public ActivityEnvironmentSelectorTree() {
        this.setRootVisible(false);
        this.setEditor_TreeModel(new EnvironmentSelectorTreeModel(this));
        this.setCellRenderer(new LD_SelectorTree.LD_SelectorTreeTreeRenderer());
        this.setToggleClickCount(0);
    }

    public void setActivity(Activity activity) {
        this._activity = activity;
        if (this.getDataModel() == null) {
            this.setDataModel(activity.getDataModel());
        }
        ((EnvironmentSelectorTreeModel)this.getEditor_TreeModel()).setActivity(activity);
    }

    public void nodeSelected(Editor_TreeNode node) {
        Object o = node.getUserObject();
        if (!(o instanceof LD_Grouping)) {
            node.setSelected(!node.isSelected());
        }
    }

    public void cleanup() {
        super.cleanup();
        this._activity = null;
    }

    class EnvironmentSelectorTreeModel
    extends Editor_TreeModel {
        private DataComponent[] _referencedComponents;
        private Environments_Grouping _rootGroup;

        public EnvironmentSelectorTreeModel(DweezilTree tree) {
            super(tree);
            this.setSelectNodeOnAdd(false);
        }

        public void setDataModel(DataModel ldDataModel) {
            super.setDataModel(ldDataModel);
            this._rootGroup = ((LD_DataModel)ldDataModel).getEnvironment_Grouping();
        }

        public void setActivity(Activity activity) {
            this._referencedComponents = activity.getEnvironments();
            this.root = new Editor_TreeNode(this._rootGroup);
            this.buildChildren((Editor_TreeNode)((Object)this.root));
            this.reload();
        }

        protected void buildChildren(Editor_TreeNode node) {
            IDataContainer component;
            Object obj = node.getUserObject();
            if (obj instanceof IDataContainer && (component = (IDataContainer)obj).hasChildren()) {
                DataComponent[] children = component.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (this.isAlreadyReferencedComponent(children[i])) continue;
                    Editor_TreeNode childNode = new Editor_TreeNode(children[i]);
                    node.add((MutableTreeNode)((Object)childNode));
                }
            }
        }

        private boolean isAlreadyReferencedComponent(DataComponent component) {
            for (int i = 0; i < this._referencedComponents.length; ++i) {
                if (component != this._referencedComponents[i]) continue;
                return true;
            }
            return false;
        }

        public void cleanup() {
            super.cleanup();
            this._referencedComponents = null;
        }
    }
}

