/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.reload.dweezil.gui.FileTextField;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;

public class FileSelectorTextField
extends FileTextField
implements IIcons {
    private DataElementTextField _textField;
    private JButton _buttonFileView;

    public FileSelectorTextField(int type, String text, Icon icon) {
        super(type, text, icon);
    }

    protected void setup() {
        this.setLayout(new BorderLayout());
        this.add(this.getTextField(), "Center");
        JPanel subPanel = new JPanel(new GridLayout());
        subPanel.add(this.getFileOpenButton());
        subPanel.add(this.getFileViewButton());
        this.add(subPanel, "East");
        this.setupFileOpenAction();
        this.setupFileViewAction();
    }

    protected void setupFileViewAction() {
        if (this.getFileViewButton() != null) {
            this.getFileViewButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String text = FileSelectorTextField.this.getTextValue();
                    if (!"".equals(text)) {
                        File file = new File(text);
                        if (file.exists()) {
                            NativeLauncher.launchFile((File)file);
                        } else {
                            JOptionPane.showMessageDialog(EditorFrame.getInstance(), text + " does not exist!", "Open File", 2);
                        }
                    }
                }
            });
        }
    }

    public JButton getFileViewButton() {
        if (this._buttonFileView == null) {
            ImageIcon icon = DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/viewfile.gif");
            this._buttonFileView = new JButton(icon);
            this._buttonFileView.setPreferredSize(new Dimension(24, 0));
        }
        return this._buttonFileView;
    }

    public JTextField getTextField() {
        if (this._textField == null) {
            this._textField = new DataElementTextField();
        }
        return this._textField;
    }

    public JButton getFileOpenButton() {
        JButton b = super.getFileOpenButton();
        b.setPreferredSize(new Dimension(24, 0));
        return b;
    }
}

