/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.schemaviewer;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeRenderer;
import uk.ac.reload.editor.gui.schemaviewer.NodeViewer;
import uk.ac.reload.editor.gui.schemaviewer.SchemaTreeModel;
import uk.ac.reload.editor.gui.schemaviewer.SchemaTreeNode;
import uk.ac.reload.moonunit.SchemaController;

public class SchemaTree
extends DweezilTree
implements TreeSelectionListener,
TreeExpansionListener {
    private NodeViewer _nodeViewer;
    private SchemaTreeModel _schemaTreeModel;

    public SchemaTree(SchemaController schemaController, NodeViewer nodeViewer) {
        this._nodeViewer = nodeViewer;
        this._schemaTreeModel = new SchemaTreeModel(schemaController.getSchemaModel());
        this.setModel((TreeModel)((Object)this._schemaTreeModel));
        this.setCellRenderer((TreeCellRenderer)new DweezilTreeRenderer());
        TreePath path = new TreePath(this._schemaTreeModel.getRootNode().getPath());
        this.expandPath(path);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
    }

    public void valueChanged(TreeSelectionEvent event) {
        if (!event.isAddedPath()) {
            return;
        }
        TreePath selPath = event.getPath();
        if (selPath == null) {
            return;
        }
        SchemaTreeNode selectedNode = (SchemaTreeNode)((Object)selPath.getLastPathComponent());
        if (selectedNode == null) {
            return;
        }
        this._nodeViewer.setElement(selectedNode.getSchemaElement());
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        SchemaTreeNode node = (SchemaTreeNode)((Object)path.getLastPathComponent());
        this._schemaTreeModel.buildChildNodes(node);
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }
}

