/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.datamodel;

import org.jdom.Element;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.jdom.XMLPath;

public class DataElement {
    private DataModel _dataModel;
    private Element _ancestorElement;
    private XMLPath _xmlElementPathFragment;
    private Element _element;

    public DataElement() {
    }

    public DataElement(DataModel dataModel, Element ancestorElement, XMLPath xmlElementPathFragment) {
        this._dataModel = dataModel;
        this._ancestorElement = ancestorElement;
        this._xmlElementPathFragment = xmlElementPathFragment;
        this._element = dataModel.getSchemaDocument().getElement(ancestorElement, xmlElementPathFragment);
    }

    public DataElement(DataModel dataModel, Element element) {
        this._dataModel = dataModel;
        this._element = element;
        this._ancestorElement = element;
        this._xmlElementPathFragment = new XMLPath("");
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    public XMLPath getXMLElementPathFragment() {
        return this._xmlElementPathFragment;
    }

    public XMLPath getXMLElementPath() {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)this._ancestorElement);
        return xmlPath.appendElementName(this._xmlElementPathFragment.getPath());
    }

    public Element getAncestorElement() {
        return this._ancestorElement;
    }

    public Element getElement() {
        return this._element;
    }

    public Element createElement() {
        if (this._element == null && this._ancestorElement != null && this._xmlElementPathFragment != null) {
            this._element = this.getDataModel().getSchemaDocument().addElementByXMLPath((Object)this, this._ancestorElement, this._xmlElementPathFragment, false);
        }
        return this._element;
    }

    public void deleteElement() {
        if (this._element != null) {
            this.getDataModel().getSchemaDocument().removeElement((Object)this, this._element);
            this._element = null;
        }
    }
}

