/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.xml;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.gui.TreeIconInterface;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.moonunit.ProfiledSchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;

public abstract class CP_SchemaController
extends ProfiledSchemaController
implements TreeIconInterface,
IIcons {
    public static String defaultCPProfile = "CP Default Profile";
    private MD_SchemaController _mdController;

    public void setMD_SchemaController(MD_SchemaController mdController) {
        this._mdController = mdController;
    }

    public String getRootElementName() {
        return "manifest";
    }

    public Icon getLeafIcon(String name, Namespace ns) {
        if (!ns.getURI().equals(this.getSchemaModel().getTargetNamespaceURI())) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/node.gif");
        }
        if (name.equals("manifest")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp.gif");
        }
        if (name.equals("organizations")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/orgs.gif");
        }
        if (name.equals("organization")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/org.gif");
        }
        if (name.equals("item")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/item.gif");
        }
        if (name.equals("file")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/file.gif");
        }
        if (name.equals("metadata")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/md.gif");
        }
        if (name.equals("resources")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resources.gif");
        }
        if (name.equals("resource")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resource.gif");
        }
        if (name.equals("dependency")) {
            return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/dependency.gif");
        }
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/md-leaf.gif");
    }

    public Icon getOpenIcon(String name, Namespace ns) {
        return this.getLeafIcon(name, ns);
    }

    public Icon getClosedIcon(String name, Namespace ns) {
        return this.getLeafIcon(name, ns);
    }

    public void copySchemaFilesToFolder(File projectFolder) throws IOException {
        String versionMD = this.getMetadataVersion();
        if (versionMD != null) {
            if ("IMS Metadata 1.2.1".equals(versionMD)) {
                FileUtils.copyFolder((File)new File(EditorHandler.SCHEMASHIPPEDFOLDER, "imsmd_121"), (File)projectFolder);
            } else if ("IMS Metadata 1.2.2".equals(versionMD)) {
                FileUtils.copyFolder((File)new File(EditorHandler.SCHEMASHIPPEDFOLDER, "imsmd_122"), (File)projectFolder);
            } else if ("IMS Metadata 1.1".equals(versionMD)) {
                FileUtils.copyFolder((File)new File(EditorHandler.SCHEMAMODELFOLDER, "imsmd_11"), (File)projectFolder);
            }
        }
    }

    public String getMetadataVersion() {
        return this._mdController == null ? null : this._mdController.getVersion();
    }

    public MD_SchemaController getMD_SchemaController() {
        return this._mdController;
    }

    public abstract MD_SchemaController getDefaultMD_SchemaController() throws JDOMException, IOException, SchemaException;

    public File getProfileFolder() {
        return CP_EditorHandler.PROFILE_FOLDER;
    }

    public File getSchemaHelperFolder() {
        return CP_EditorHandler.SCHEMAHELPER_FOLDER;
    }

    public File getVocabFolder() {
        return CP_EditorHandler.VOCAB_FOLDER;
    }

    public String getDefaultProfileName() {
        String defProfileName = EditorPrefs.getInstance().getValue("default_cp_profile");
        return defProfileName == null ? defaultCPProfile : defProfileName;
    }
}

