/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.undo;

import java.util.Stack;
import uk.ac.reload.diva.undo.UndoListener;
import uk.ac.reload.diva.undo.UndoableAction;

public class UndoHandler {
    private Stack _undoStack;
    private Stack _redoStack;
    private UndoListener _undoListener;

    public UndoHandler() {
        this(null);
    }

    public UndoHandler(UndoListener undoListener) {
        this._undoListener = undoListener;
        this._undoStack = new Stack();
        this._redoStack = new Stack();
    }

    public void addUndoableAction(UndoableAction action) {
        this._undoStack.push(action);
        this._redoStack.removeAllElements();
        if (this._undoListener != null) {
            this._undoListener.undoableActionHappened(action);
        }
    }

    public UndoableAction undoLastAction() {
        UndoableAction action = null;
        if (!this._undoStack.empty()) {
            action = (UndoableAction)this._undoStack.pop();
            action.undo();
            this._redoStack.push(action);
        }
        return action;
    }

    public UndoableAction redoLastAction() {
        UndoableAction action = null;
        if (!this._redoStack.empty()) {
            action = (UndoableAction)this._redoStack.pop();
            action.redo();
            this._undoStack.push(action);
        }
        return action;
    }

    public void clearAll() {
        this._undoStack.clear();
        this._redoStack.clear();
    }

    public UndoableAction nextUndoAction() {
        UndoableAction nextAction = null;
        if (!this._undoStack.empty()) {
            nextAction = (UndoableAction)this._undoStack.peek();
        }
        return nextAction;
    }

    public UndoableAction nextRedoAction() {
        UndoableAction nextAction = null;
        if (!this._redoStack.empty()) {
            nextAction = (UndoableAction)this._redoStack.peek();
        }
        return nextAction;
    }
}

