/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.jdom;

import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.Element;

public class XMLPath {
    public static String XMLPATHSEPARATOR = "/";
    public static String XMLATTSEPARATOR = "@";
    private String _path;

    public XMLPath(String path) {
        this._path = path;
    }

    public XMLPath(XMLPath xmlPath) {
        this._path = xmlPath.getPath();
    }

    public String getPath() {
        return this._path;
    }

    public XMLPath appendElementName(String elementName) {
        if (elementName != null && !"".equals(elementName)) {
            this._path = this._path + XMLPATHSEPARATOR + elementName;
        }
        return this;
    }

    public XMLPath prependElementName(String elementName) {
        this._path = elementName + XMLPATHSEPARATOR + this._path;
        return this;
    }

    public XMLPath appendAttributeName(String attributeName) {
        this._path = this._path + XMLATTSEPARATOR + attributeName;
        return this;
    }

    public StringTokenizer getElements() {
        String path = this.getElementsPart();
        return new StringTokenizer(path, XMLPATHSEPARATOR);
    }

    public boolean isAttribute() {
        return this._path.indexOf(XMLATTSEPARATOR) != -1;
    }

    public String getAttributePart() {
        int index = this._path.indexOf(XMLATTSEPARATOR);
        if (index != -1) {
            return this._path.substring(index + 1);
        }
        return null;
    }

    public String getElementsPart() {
        int index = this._path.indexOf(XMLATTSEPARATOR);
        if (index != -1) {
            return this._path.substring(0, index);
        }
        return this._path;
    }

    public String getRootPart() {
        int index = this._path.indexOf(XMLPATHSEPARATOR);
        if (index != -1) {
            return this._path.substring(0, index);
        }
        return this._path;
    }

    public String getLastPart() {
        if (this.isAttribute()) {
            return this.getAttributePart();
        }
        int index = this._path.lastIndexOf(XMLPATHSEPARATOR);
        if (index != -1) {
            return this._path.substring(index + 1);
        }
        return this._path;
    }

    public boolean equals(XMLPath xmlPath) {
        return this._path.equals(xmlPath.getPath());
    }

    public boolean endsWith(XMLPath xmlPath) {
        return this._path.endsWith(xmlPath.getPath());
    }

    public String toString() {
        return this._path;
    }

    public static XMLPath getXMLPathForElement(Element element) {
        Element parent;
        if (element == null) {
            return null;
        }
        String name = element.getName();
        while ((parent = element.getParent()) != null) {
            String prefix;
            if (!parent.getNamespace().equals((Object)element.getNamespace()) && !"".equals(prefix = element.getNamespacePrefix())) {
                name = prefix + ":" + name;
            }
            name = parent.getName() + XMLPATHSEPARATOR + name;
            element = parent;
        }
        XMLPath xmlPath = new XMLPath(name);
        return xmlPath;
    }

    public static XMLPath getXMLPathForAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        Element parent = attribute.getParent();
        if (parent != null) {
            XMLPath xmlPath = XMLPath.getXMLPathForElement(attribute.getParent());
            xmlPath.appendAttributeName(attribute.getQualifiedName());
            return xmlPath;
        }
        XMLPath xmlPath = new XMLPath(attribute.getQualifiedName());
        return xmlPath;
    }
}

