-- $Id: create_lams_tool_behaviourComposer.sql,v 1.16 2006/03/21 06:54:17 fmalikoff Exp $

CREATE TABLE tl_kkbc10_content (
       uid BIGINT(20) NOT NULL AUTO_INCREMENT
     , behaviourComposer_content_id BIGINT(20) UNIQUE NOT NULL
     , title TEXT
     , content TEXT
     , online_instructions TEXT
     , offline_instructions TEXT
     , define_later TINYINT(1)
     , force_offline TINYINT(1)
     , content_in_use TINYINT(1)
     , creator_user_id BIGINT(20)
     , date_created DATETIME
     , date_updated DATETIME
     , PRIMARY KEY (uid)
)TYPE=InnoDB;

CREATE TABLE tl_kkbc10_session (
       uid BIGINT(20) NOT NULL AUTO_INCREMENT
     , behaviourComposer_session_id BIGINT(20) UNIQUE NOT NULL
     , behaviourComposer_session_name VARCHAR(255) NOT NULL
     , behaviourComposer_content_uid BIGINT(20) NOT NULL
     , session_start_date DATETIME
     , session_end_date DATETIME
     , session_status VARCHAR(100)
     , PRIMARY KEY (uid)
     , INDEX (behaviourComposer_content_uid)
     , CONSTRAINT FK_tl_kkbc10_session_1 FOREIGN KEY (behaviourComposer_content_uid)
                  REFERENCES tl_kkbc10_content (uid)
)TYPE=InnoDB;

CREATE TABLE tl_kkbc10_user (
       uid BIGINT(20) NOT NULL AUTO_INCREMENT
     , user_id BIGINT(20) NOT NULL
     , behaviourComposer_session_uid BIGINT(20) NOT NULL
     , username VARCHAR(50)
     , fullname VARCHAR(50)
     , user_status VARCHAR(50)
     , PRIMARY KEY (uid)
     , INDEX (behaviourComposer_session_uid)
     , CONSTRAINT FK_tl_kkbc10_user_1 FOREIGN KEY (behaviourComposer_session_uid)
                  REFERENCES tl_kkbc10_session (uid)
)TYPE=InnoDB;


CREATE TABLE tl_kkbc10_attachment (
       attachment_id BIGINT(20) NOT NULL AUTO_INCREMENT
     , behaviourComposer_content_uid BIGINT(20) NOT NULL
     , filename VARCHAR(255) NOT NULL
     , uuid BIGINT(20) NOT NULL
     , version_id BIGINT(20)
     , online_file TINYINT(1) NOT NULL
     , PRIMARY KEY (attachment_id)
     , INDEX (behaviourComposer_content_uid)
     , CONSTRAINT FK_tl_kkbc10_attachment_1 FOREIGN KEY (behaviourComposer_content_uid)
                  REFERENCES tl_kkbc10_content (uid)
)TYPE=InnoDB;

-- Default Content For BehaviourComposer Tool

INSERT INTO tl_kkbc10_content ( behaviourComposer_content_id,
								title,
								content,
								online_instructions,
								offline_instructions,
								define_later,
								force_offline,
								content_in_use,
								date_created) 
VALUES (${default_content_id},
		'BehaviourComposer',
		'Specify the initial page and model below...',
		'Enter the online instructions here',
		'Enter the offline instructions here',
		0,
		0,
		0,
		now());


