/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestToolSessionManager.java,v 1.6 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.service;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerDataAccessTestCase;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.behaviourComposer.service.IBehaviourComposerService;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerConstants;

/**
 * @author mtruong
 *
 * *TODO: the default content id is now not hard coded and taken from the database, ensure the test cases stillw ork
 */
public class TestToolSessionManager extends BehaviourComposerDataAccessTestCase {
    
    private ToolSessionManager behaviourComposerSessionManager = null;
    private IBehaviourComposerService behaviourComposerService = null;
    private boolean cleanContentData = true;
    private static final Long NEW_SESSION_ID = new Long(3400);
    private static final String NEW_SESSION_NAME = "SessionName";
    
    public TestToolSessionManager(String name)
	{
		super(name);
	}
    
   protected void setUp() throws Exception
	{
		super.setUp();
		//setup some data
		this.behaviourComposerContent = null;
		this.behaviourComposerSession = null;
		behaviourComposerSessionManager = (ToolSessionManager)this.context.getBean("behaviourComposerService");
		behaviourComposerService = (IBehaviourComposerService)this.context.getBean("behaviourComposerService");
		initBehaviourComposerContentData();
	    initBehaviourComposerSessionContent();
	}
	
	protected void tearDown() throws Exception
	{
		//delete data
		if(cleanContentData)
        {
        	cleanBehaviourComposerContentData(TEST_NB_ID);
        }
	
     }
	
	/* Normal case: with valid toolSessionId and toolContentId */
	
	public void testCreateToolSession() throws ToolException
	{
	    try
	    {
	        behaviourComposerSessionManager.createToolSession(NEW_SESSION_ID,NEW_SESSION_NAME, TEST_NB_ID);
		    
		    behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(NEW_SESSION_ID);
		    
		    assertEquals(behaviourComposerSession.getBehaviourComposerSessionId(), NEW_SESSION_ID);
		    assertEquals(behaviourComposerSession.getBehaviourComposerContent().getBehaviourComposerContentId(), TEST_NB_ID);
	        
	    }
	    catch (ToolException e)
	    {
	        fail("An exception should not have been thrown");
	        assertTrue(false);
	    }
	   
	}

	/*
	 * Error case: the supplied toolSessionId is null
	 */
	public void testCreateToolSessionWithNullSessionId() throws ToolException
	{
	    try
	    {
	        behaviourComposerSessionManager.createToolSession(null, NEW_SESSION_NAME,TEST_NB_ID);
	        fail("An exception should be raised as the toolSessionId is null");
	    }
	    catch(ToolException e)
	    {
	        assertTrue(true);
	    }
	}
	
	/*
	 * Error case: the supplied toolContentId is null
	 */
	public void testCreateToolSessionWithNullContentId() throws ToolException
	{
	    try
	    {
	        behaviourComposerSessionManager.createToolSession(NEW_SESSION_ID,NEW_SESSION_NAME,  null);
	        fail("An exception should be raised as the toolContentId is null");
	    }
	    catch(ToolException e)
	    {
	        assertTrue(true);
	    }
	}
	
	/*
	 * Alternative case: the supplied toolSessionId is invalid (has no content)
	 */
	
	public void testCreateToolSessionWithInvalidContentId() throws ToolException
	{
	    Long invalidId = new Long(8968);
	    try
	    {
	        behaviourComposerSessionManager.createToolSession(NEW_SESSION_ID, NEW_SESSION_NAME, invalidId);	    
		    
	        behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(NEW_SESSION_ID);
		    
		    assertEquals("validating session id:", behaviourComposerSession.getBehaviourComposerSessionId(), NEW_SESSION_ID);
		    assertEquals("Validating content Id:", behaviourComposerSession.getBehaviourComposerContent().getBehaviourComposerContentId(), behaviourComposerService.getToolDefaultContentIdBySignature(BehaviourComposerConstants.TOOL_SIGNATURE));
		    assertContentEqualsDefaultData(behaviourComposerSession.getBehaviourComposerContent());
	    }
	    catch (ToolException e)
	    {
	        fail("An exception should not have been thrown");
	        assertTrue(false);
	    }
	} 
	/*
	 * Error case: the default content is missing, throws ToolException
	 */
	
	public void testCreateToolSessionDefaultContentMissing() throws ToolException
	{
		Long defaultContentId = behaviourComposerService.getToolDefaultContentIdBySignature(BehaviourComposerConstants.TOOL_SIGNATURE);
	    behaviourComposerService.removeBehaviourComposer(defaultContentId);
	    
	    try
	    {
	        behaviourComposerSessionManager.createToolSession(NEW_SESSION_ID, NEW_SESSION_NAME, null);
	        fail("An exception should be raised since the toolContentId"
	                + "is null and the defaultContent is missing");
	    }
	    catch (ToolException e)
	    {
	        assertTrue(true);
	    }
	    
	    restoreDefaultContent(defaultContentId);
	} 
	
	/*
	 * Normal case: 
	 */
	public void testRemoveToolSession() throws ToolException, DataMissingException
	{
	    try
	    {
	        behaviourComposerSessionManager.removeToolSession(TEST_SESSION_ID);
	        
	        behaviourComposerSession = behaviourComposerService.retrieveBehaviourComposerSession(TEST_SESSION_ID);
	        assertNull(behaviourComposerSession);
	    }
	    catch(DataMissingException e)
	    {
	        fail("An exception should not have been thrown");
	        assertTrue(false);
	    }
	    catch(ToolException e)
	    {
	        fail("An exception should not have been thrown");
	        assertTrue(false);
	    }
	}
	
	public void testRemoveToolSessionWithSessionIdNull() throws ToolException, DataMissingException
	{
	    try
	    {
	        behaviourComposerSessionManager.removeToolSession(null);
	        fail("An exception should have been raised as the session id is null");
	    }
	    catch(ToolException e)
	    {
	        assertTrue(true);
	    }
	}
	
	public void testRemoveToolSessionWithInvalidId() throws ToolException, DataMissingException//no session data
	{
	    try
	    {
	        Long invalidId = new Long(878);
	        behaviourComposerSessionManager.removeToolSession(invalidId);
	        fail("An exception should have been raised as there is no corresponding session data");
	    }
	    catch(DataMissingException e)
	    {
	        assertTrue(true);
	    }
	}
}
