/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerUserDAO.java,v 1.6 2006/07/14 04:56:36 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerDataAccessTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;

/**
 * @author mtruong
 */
public class TestBehaviourComposerUserDAO extends BehaviourComposerDataAccessTestCase {
    
    private BehaviourComposerUser behaviourComposerUser;
    private BehaviourComposerSession behaviourComposerSession;
    
    private BehaviourComposerContent content;
   
    private boolean cleanContentData = true;
    
    public TestBehaviourComposerUserDAO(String name)
    {
        super(name);
    }
    
    /**
     * @see BehaviourComposerDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
	 	super.setUp();
       
        initAllData();
     
    }
	 
	 protected void tearDown() throws Exception {
	    
	     if(cleanContentData)
	     {
	     	cleanBehaviourComposerContentData(TEST_NB_ID);
	     }
	 }
	 
	

	 public void testGetBehaviourComposerUserByID()
	 {
	     behaviourComposerUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(TEST_USER_ID);
	     
	     assertEqualsForBehaviourComposerUser(behaviourComposerUser);
	     
	     Long nonExistentUserId = new Long(23321);
	     assertUserObjectIsNull(nonExistentUserId);
	 }
	 
	 public void testSaveBehaviourComposerUser()
	 {
	     BehaviourComposerSession sessionToReference = behaviourComposerSessionDAO.findBehaviourComposerSessionById(TEST_SESSION_ID);
	    
	     Long newUserId = new Long(3849);
	     
	     BehaviourComposerUser newUserObj = new BehaviourComposerUser(newUserId,
	             											sessionToReference);
	        
	     sessionToReference.getBehaviourComposerUsers().add(newUserObj);
	     behaviourComposerSessionDAO.updateBehaviourComposerSession(sessionToReference);
	     
	     behaviourComposerUserDAO.saveBehaviourComposerUser(newUserObj);   
	        
	     //Retrieve the newly added session object and test its values
	     behaviourComposerUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(newUserId);
	     
	     assertEquals(behaviourComposerUser.getUserId(), newUserId);
	     assertEquals(behaviourComposerUser.getBehaviourComposerSession().getBehaviourComposerSessionId(),TEST_SESSION_ID);
	 } 
	 public void testUpdateBehaviourComposerUser()
	 {
	     behaviourComposerUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(TEST_USER_ID);
	     behaviourComposerUser.setUserStatus(BehaviourComposerUser.COMPLETED);
	     behaviourComposerUserDAO.updateBehaviourComposerUser(behaviourComposerUser);
	     
	     BehaviourComposerUser modifiedUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(TEST_USER_ID);
	     assertEquals(modifiedUser.getUserStatus(), BehaviourComposerUser.COMPLETED);
	 }
	 
	 public void testRemoveBehaviourComposerUserById()
	 {
	    behaviourComposerUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(TEST_USER_ID);
	    behaviourComposerSession = behaviourComposerUser.getBehaviourComposerSession();
	    behaviourComposerSession.getBehaviourComposerUsers().remove(behaviourComposerUser);
	     
	     behaviourComposerUserDAO.removeBehaviourComposerUser(TEST_USER_ID);
	     behaviourComposerSessionDAO.updateBehaviourComposerSession(behaviourComposerSession);
	    
	     assertUserObjectIsNull(TEST_USER_ID);
	 }
	 
	 public void testRemoveBehaviourComposerUser()
	 {
	     behaviourComposerUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(TEST_USER_ID);
		 behaviourComposerSession = behaviourComposerUser.getBehaviourComposerSession();
		 behaviourComposerSession.getBehaviourComposerUsers().remove(behaviourComposerUser);
		     
		 behaviourComposerUserDAO.removeBehaviourComposerUser(behaviourComposerUser);
		 behaviourComposerSessionDAO.updateBehaviourComposerSession(behaviourComposerSession);
		    
		 assertUserObjectIsNull(TEST_USER_ID);
	 }
	 
	 public void testGetNumberOfUsers()
	 {
	     behaviourComposerUser = behaviourComposerUserDAO.getBehaviourComposerUserByID(TEST_USER_ID);
	     behaviourComposerSession = behaviourComposerUser.getBehaviourComposerSession();
	     int numberOfUsers = behaviourComposerUserDAO.getNumberOfUsers(behaviourComposerSession);
	     System.out.println(numberOfUsers);
	     assertEquals(numberOfUsers, 1);
	 } 
	 
	 public void testGetBehaviourComposerUserBySession()
	 {
	 	Long newSessionId = new Long(3456);
	 	
	 	BehaviourComposerContent content = behaviourComposerDAO.findBehaviourComposerContentById(TEST_NB_ID);
	 	
	 	BehaviourComposerSession newSession = new BehaviourComposerSession(newSessionId, "Session "+newSessionId, content);
	 	content.getBehaviourComposerSessions().add(newSession);
	 	behaviourComposerDAO.updateBehaviourComposerContent(content);
	 	behaviourComposerSessionDAO.saveBehaviourComposerSession(newSession);
	 	
	 	//add the test user to a new session
	 	BehaviourComposerUser existingUserNewSession = new BehaviourComposerUser(TEST_USER_ID, newSession);
	 	newSession.getBehaviourComposerUsers().add(existingUserNewSession);
	 	behaviourComposerSessionDAO.updateBehaviourComposerSession(newSession);
	 	
	 	behaviourComposerUserDAO.saveBehaviourComposerUser(existingUserNewSession);
	 	
	 	//add a different user to the session
	 	Long newUserId= new Long(3458);
	 	BehaviourComposerUser newUser = new BehaviourComposerUser(newUserId, newSession);
	 	newSession.getBehaviourComposerUsers().add(newUser);
	 	behaviourComposerSessionDAO.updateBehaviourComposerSession(newSession);
	 	behaviourComposerUserDAO.saveBehaviourComposerUser(newUser);
	 	
	 	//retrieve test user by session	id	
	 	BehaviourComposerUser retrievedUser = behaviourComposerUserDAO.getBehaviourComposerUserBySession(TEST_USER_ID, newSessionId);
	 	assertEquals(retrievedUser.getUserId(), TEST_USER_ID);
	 	assertEquals(retrievedUser.getBehaviourComposerSession().getBehaviourComposerSessionId(), newSessionId);
	 	
	 	BehaviourComposerUser retrievedUser2 = behaviourComposerUserDAO.getBehaviourComposerUserBySession(newUserId, newSessionId);
	 	assertEquals(retrievedUser2.getUserId(), newUserId);
	 	assertEquals(retrievedUser.getBehaviourComposerSession().getBehaviourComposerSessionId(), newSessionId);
	 	
	 } 
	 
	 
	 
	


}
