/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerUserDAO.java,v 1.7 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;

/**
 * @author mtruong
 * <p>Hibernate implementation for database access to BehaviourComposer users (learners) for the behaviourComposer tool.</p>
 */
public class BehaviourComposerUserDAO extends HibernateDaoSupport implements IBehaviourComposerUserDAO {
    
	private static final String FIND_NB_USER = "from " + BehaviourComposerUser.class.getName() + " as behaviourComposer where behaviourComposer.userId=?";
	
	private static final String FIND_NB_USER_BY_SESSION = "from " + BehaviourComposerUser.class.getName() + " as behaviourComposer where behaviourComposer.userId=? and behaviourComposer.behaviourComposerSession.behaviourComposerSessionId=?";
	
    private static final String COUNT_USERS_IN_SESSION = "select nu.userId from BehaviourComposerUser nu where nu.behaviourComposerSession= :behaviourComposerSession";
   
  
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO#getBehaviourComposerUserByID(java.lang.Long) */
	public BehaviourComposerUser getBehaviourComposerUserByID(Long userId)
	{
	    String query = "from BehaviourComposerUser user where user.userId=?";
	    List users = getHibernateTemplate().find(query,userId);
		
		if(users!=null && users.size() == 0)
		{			
			return null;
		}
		else
		{
			return (BehaviourComposerUser)users.get(0);
		}
	}
	
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO#getBehaviourComposerUserBySession(java.lang.Long, java.lang.Long)*/
	public BehaviourComposerUser getBehaviourComposerUserBySession(Long userId, Long sessionId)
	{	
		List usersReturned = getSession().createQuery(FIND_NB_USER_BY_SESSION)
			.setLong(0,userId.longValue())
			.setLong(1, sessionId.longValue())
			.list();
	
		if(usersReturned != null && usersReturned.size() > 0){
			BehaviourComposerUser behaviourComposer = (BehaviourComposerUser) usersReturned.get(0);
			return behaviourComposer;
		}
		else
			return null;

	}

	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO#saveBehaviourComposerUser(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser) */
	public void saveBehaviourComposerUser(BehaviourComposerUser behaviourComposerUser)
    {
    	this.getHibernateTemplate().save(behaviourComposerUser);
    }
	
	/** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO#updateBehaviourComposerUser(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser) */
    public void updateBehaviourComposerUser(BehaviourComposerUser behaviourComposerUser)
    {
    	this.getHibernateTemplate().update(behaviourComposerUser);
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO#removeBehaviourComposerUser(java.lang.Long) */
    public void removeBehaviourComposerUser(Long userId)
    {
		if ( userId != null) {
			//String query = "from org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent as behaviourComposer where behaviourComposer.behaviourComposerContentId=?";
			List list = getSession().createQuery(FIND_NB_USER)
				.setLong(0,userId.longValue())
				.list();
			
			if(list != null && list.size() > 0){
				BehaviourComposerUser behaviourComposer = (BehaviourComposerUser) list.get(0);
				this.getSession().setFlushMode(FlushMode.AUTO);
				this.getHibernateTemplate().delete(behaviourComposer);
				this.getHibernateTemplate().flush();
			}
		}
      
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO#removeBehaviourComposerUser(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser) */
    public void removeBehaviourComposerUser(BehaviourComposerUser behaviourComposerUser)
    {
       // this.getHibernateTemplate().delete(behaviourComposerUser);
    	removeBehaviourComposerUser(behaviourComposerUser.getUserId());
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerUserDAO#getNumberOfUsers((org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession) */
    public int getNumberOfUsers(BehaviourComposerSession behaviourComposerSession)
    {
        return (getHibernateTemplate().findByNamedParam(COUNT_USERS_IN_SESSION,
	            "behaviourComposerSession",
				behaviourComposerSession)).size();
    }
    
    
}
