/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerAttachmentDAO.java,v 1.7 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import java.util.List;

import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerAttachment;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
/**
 * @author mtruong
 *
 * <p>Hibernate implementation for database access of behaviourComposer attachment,
 * which are generally the uploads, updates and removal of online/offline
 * instruction files </p>
 */
public class BehaviourComposerAttachmentDAO extends HibernateDaoSupport implements IBehaviourComposerAttachmentDAO {
	
	private static final String FIND_NB_ATTACHMENT_BY_UUID = "from " + BehaviourComposerAttachment.class.getName() + " as behaviourComposer where behaviourComposer.uuid=?";
	private static final String FIND_NB_ATTACHMENT_BY_FILENAME = "from " + BehaviourComposerAttachment.class.getName() + " as behaviourComposer where behaviourComposer.filename=?";
	private static final String GET_ATTACHMENT_FROM_CONTENT = "select behaviourComposer.attachmentId from " + BehaviourComposerAttachment.class.getName() + " as behaviourComposer where behaviourComposer.behaviourComposerContent= :behaviourComposerContent";
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO#retrieveAttachment(java.lang.Long) */
    public BehaviourComposerAttachment retrieveAttachment(Long attachmentId)
    {
        return (BehaviourComposerAttachment)this.getHibernateTemplate().get(BehaviourComposerAttachment.class, attachmentId);
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO#retrieveAttachmentByUuid(java.lang.Long) */
    public BehaviourComposerAttachment retrieveAttachmentByUuid(Long uuid)
    {
        List attachments = getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID)
		.setLong(0,uuid.longValue())
		.list();

		if(attachments != null && attachments.size() > 0){
			BehaviourComposerAttachment behaviourComposer = (BehaviourComposerAttachment) attachments.get(0);
			return behaviourComposer;
		}
		else
			return null;
	    	
    	
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO#retrieveAttachmentByFilename(java.lang.String) */
    public BehaviourComposerAttachment retrieveAttachmentByFilename(String filename)
    {
    	List attachments = getSession().createQuery(FIND_NB_ATTACHMENT_BY_FILENAME)
		.setString(0, filename)
		.list();

		if(attachments != null && attachments.size() > 0){
			BehaviourComposerAttachment behaviourComposer = (BehaviourComposerAttachment) attachments.get(0);
			return behaviourComposer;
		}
		else
			return null;
    }
    
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO#getAttachmentIdsFromContent(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent) */
    public List getAttachmentIdsFromContent(BehaviourComposerContent behaviourComposerContent)
    {
        return (getHibernateTemplate().findByNamedParam(GET_ATTACHMENT_FROM_CONTENT,
	            "behaviourComposerContent",
				behaviourComposerContent));
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO#saveAttachment(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent) */
    public void saveAttachment(BehaviourComposerAttachment attachment)
    {
        this.getHibernateTemplate().saveOrUpdate(attachment);
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO#removeAttachment(org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent) */
    public void removeAttachment(BehaviourComposerAttachment attachment)
    {
    	//this.getHibernateTemplate().delete(attachment);
    	removeAttachment(attachment.getUuid());
    }
    
    /** @see org.lamsfoundation.lams.tool.behaviourComposer.dao.IBehaviourComposerAttachmentDAO#removeAttachment(java.lang.Long) */
    public void removeAttachment(Long uuid)
    {
        //this.getHibernateTemplate().delete(retrieveAttachmentByUuid(uuid));
    	List attachments = getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID)
		.setLong(0,uuid.longValue())
		.list();

		if(attachments != null && attachments.size() > 0){
			BehaviourComposerAttachment behaviourComposer = (BehaviourComposerAttachment) attachments.get(0);
			this.getSession().setFlushMode(FlushMode.AUTO);
			this.getHibernateTemplate().delete(behaviourComposer);
			this.getHibernateTemplate().flush();
		}
    	
    }
}
