/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: IBehaviourComposerUserDAO.java,v 1.6 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;

/**
 * @author mtruong
 * 
 * <p>Interface for the BehaviourComposerSession DAO, defines methods needed to access/modify
 * behaviourComposer users (learners of the behaviourComposer activity) </p>
 */
public interface IBehaviourComposerUserDAO {
    
   
    /**
	 * <p> Return the persistent instance of a BehaviourComposerUser
	 * with the given user id <code>userId</code>,
	 * returns null if not found.</p>
	 * 
	 * @param userId The id of a BehaviourComposerUser
	 * @return the persistent instance of a BehaviourComposerUser or null if not found.
	 */
    public BehaviourComposerUser getBehaviourComposerUserByID(Long userId);
    
    /**
	 * <p> Return the persistent instance of a BehaviourComposerUser
	 * who has the user id <code>userId</code> and tool session id
	 * <code>sessionId</code>
	 * returns null if not found.</p>
	 * 
	 * @param userId. The id of the learner
	 * @param sessionId. The tool session id to which this user belongs to.
	 * @return the persistent instance of a BehaviourComposerUser or null if not found.
	 */
    public BehaviourComposerUser getBehaviourComposerUserBySession(Long userId, Long sessionId);
    
    /**
	 * <p>Persist the given persistent instance of BehaviourComposerUser.</p>
	 * 
	 * @param behaviourComposerUser The instance of BehaviourComposerUser to persist.
	 */
    public void saveBehaviourComposerUser(BehaviourComposerUser behaviourComposerUser);
    
    /**
     * <p>Update the given persistent instance of BehaviourComposerUser.</p>
     * 
     * @param behaviourComposerUser The instance of BehaviourComposerUser to persist.
     */
    public void updateBehaviourComposerUser(BehaviourComposerUser behaviourComposerUser);
    
    /**
     * <p>Delete the given instance of BehaviourComposerUser</p>
     * 
     * @param behaviourComposerUser The instance of BehaviourComposerUser to delete. 
     */
    public void removeBehaviourComposerUser(BehaviourComposerUser behaviourComposerUser);
    
    /**
     * <p>Delete the given instance of BehaviourComposerUser with the
     * given user id <code>userId</code>
     * 
     * @param userId The behaviourComposer user id.
     */
    public void removeBehaviourComposerUser(Long userId);
    
    /**
     * Returns the number of users that are in this particular
     * session.
     * 
     * @param behaviourComposerSession
     * @return the number of users that are in this session
     */
    public int getNumberOfUsers(BehaviourComposerSession behaviourComposerSession);
   
}
