/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerContent.java,v 1.16 2006/09/07 00:18:32 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;


/**
 * <p>Persistent behaviourComposer object/bean that defines the content for the behaviourComposer tool.
 * Provides accessors and mutators to get/set behaviourComposer attributes</p>
 * @hibernate.class table="tl_kkbc10_content"
 * @author mtruong
 */
public class BehaviourComposerContent implements Serializable {
	
	/** identifier field */
    private Long uid;
    
    /** non-nullable persistent field */
	private Long behaviourComposerContentId;
	
	/** nullable persistent field */
	private String title;
	
	/** nullable persistent field */
	private String content;
	
	/** nullable persistent field */
	private String onlineInstructions;
	
	/** nullable persistent field */
	private String offlineInstructions;
	
	/** nullable persistent field */
	private boolean defineLater;
	
	/** nullable persistent field */
	private boolean forceOffline;

	/** nullable persistent field */
	private boolean contentInUse;
	
	/** nullable persistent field */
	private Long creatorUserId;
	
	/** nullable persistent field */
	private Date dateCreated;
	
	/** nullable persistent field */
	private Date dateUpdated;
	
	/** persistent field */
	private Set behaviourComposerSessions = new HashSet();
	
	private Set behaviourComposerAttachments = new HashSet();
	
	/** default constructor */
	public BehaviourComposerContent()
	{
	}
	
	/** full constructor */
	public BehaviourComposerContent(Long behaviourComposerContentId,
							  String title,
							  String content,
							  String onlineInstructions,
							  String offlineInstructions,
							  boolean defineLater,
							  boolean forceOffline,
							  boolean contentInUse,
							  Long creatorUserId,
							  Date dateCreated,
							  Date dateUpdated)
	{
		this.behaviourComposerContentId = behaviourComposerContentId;
		this.title = title;
		this.content = content;
		this.onlineInstructions = onlineInstructions;
		this.offlineInstructions = offlineInstructions;
		this.defineLater = defineLater;
		this.forceOffline = forceOffline;
		this.contentInUse = contentInUse;
		this.creatorUserId = creatorUserId;
		this.dateCreated = dateCreated;
		this.dateUpdated = dateUpdated;
	}
	
	/**
	 * Minimal Constructor used to initialise values for the BehaviourComposerContent object
	 * @return
	 */
	
	public BehaviourComposerContent(Long behaviourComposerContentId,
	        				  String title,
	        				  String content,
	        				  String onlineInstructions,
	        				  String offlineInstructions,
	        				  Date dateCreated)
	{
	    this.behaviourComposerContentId = behaviourComposerContentId;
		this.title = title;
		this.content = content;
		this.onlineInstructions = onlineInstructions;
		this.offlineInstructions = offlineInstructions;
		this.defineLater = false;
		this.forceOffline = false;
		this.contentInUse = false;
		this.creatorUserId = null;
		this.dateCreated = dateCreated;
		this.dateUpdated = null;
	}
	
	
    
	/**
	 *		 @hibernate.property
     *       column="content"
     *       length="65535"
	 */
	
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	/**
	 * 
	 *		@hibernate.property
     *		column="creator_user_id"
     *		length="20"
     */	
	public Long getCreatorUserId() {
		return creatorUserId;
	}
	
	public void setCreatorUserId(Long creatorUserId) {
		this.creatorUserId = creatorUserId;
	}
	
	/**
	 * 
	 *		@hibernate.property
     *		column="date_created"
     *		length="19"
     */
	public Date getDateCreated() {
		return dateCreated;
	}
	
	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}
	
	/**
	 * 
	 *		@hibernate.property
     *		column="date_updated"
     *		length="19"
     */
	public Date getDateUpdated() {
		return dateUpdated;
	}
	
	public void setDateUpdated(Date dateUpdated) {
		this.dateUpdated = dateUpdated;
	}
	
	/** 
	 *		@hibernate.property
     *		column="define_later"
     *		length="1"
     */
	public boolean isDefineLater() {
		return defineLater;
	}
	
	public void setDefineLater(boolean defineLater) {
		this.defineLater = defineLater;
	}
	
	/** 
	 *		@hibernate.property
     *		column="force_offline"
     *		length="1"
     */
	public boolean isForceOffline() {
		return forceOffline;
	}
	
	public void setForceOffline(boolean forceOffline) {
		this.forceOffline = forceOffline;
	}
	
	 /** 
	 *		@hibernate.property
     *		column="content_in_use"
     *		length="1"
     */
    
    public boolean isContentInUse() {
        return contentInUse;
    }
    /**
     * @param contentInUse The contentInUse to set.
     */
    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }
	
	/** 
	 *		@hibernate.property
     *      column="behaviourComposer_content_id"
     *      length="20"
     *      not-null="true"
     */
	
	public Long getBehaviourComposerContentId() {
		return behaviourComposerContentId;
	}
	
	public void setBehaviourComposerContentId(Long behaviourComposerContentId) {
		this.behaviourComposerContentId = behaviourComposerContentId;
	}
	/**
	 * 		@hibernate.set
     *      lazy="true"
     *      inverse="true"
     *      cascade="all-delete-orphan"
     *     	@hibernate.collection-key
     *      column="behaviourComposer_content_uid"
     *     	@hibernate.collection-one-to-many
     *      class="org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession"
     */
	public Set getBehaviourComposerSessions() {
		if (this.behaviourComposerSessions == null)
		{
			setBehaviourComposerSessions(new HashSet());
		}
		return behaviourComposerSessions;
	}
	
	public void setBehaviourComposerSessions(Set behaviourComposerSessions) {
		this.behaviourComposerSessions = behaviourComposerSessions;
	}
	
	/**
     *  	@hibernate.set
     *      lazy="true"
     *      inverse="true"
     *      cascade="all-delete-orphan"
     *      @hibernate.collection-key
     *      column="behaviourComposer_content_uid"
     * 		@hibernate.collection-one-to-many
     *      class="org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerAttachment"
     */
    public Set getBehaviourComposerAttachments() {
        return behaviourComposerAttachments;
    }
    /**
     * @param behaviourComposerAttachments The behaviourComposerAttachments to set.
     */
    public void setBehaviourComposerAttachments(Set behaviourComposerAttachments) {
        this.behaviourComposerAttachments = behaviourComposerAttachments;
    }
	
	
	
	/**
	 * 
	 *		@hibernate.property
     *		column="offline_instructions"
     *		length="65535"
     */	
	public String getOfflineInstructions() {
		return offlineInstructions;
	}
	
	public void setOfflineInstructions(String offlineInstructions) {
		this.offlineInstructions = offlineInstructions;
	}
	
	/**
	 * 
	 *		@hibernate.property
     *		column="online_instructions"
     *		length="65535"
     */	
	public String getOnlineInstructions() {
		return onlineInstructions;
	}
	
	public void setOnlineInstructions(String onlineInstructions) {
		this.onlineInstructions = onlineInstructions;
	}
	
	/**
	 * 		@hibernate.property
     *      column="title"
     *      length="65535"
	 */
	public String getTitle() {
		return title;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}
	
	 /**
      * 	@hibernate.id
      *     generator-class="native"
      *     type="java.lang.Long"
      *     column="uid"
      *     unsaved-value="0"
      */
    public Long getUid() {
        return uid;
    }
    
    public void setUid(Long uid) {
        this.uid = uid;
    }
	

   
    
    
    
    
	/** 
	 * Creates a new BehaviourComposerContent object from the supplied object.
	 * Assigns it the toContendId. Also copies all the items in the attachment set
	 * to the new object's attachment set. So while the two contents have different
	 * attachment records, they point to the same entries in the database.
	 * 
	 * @param behaviourComposer			BehaviourComposerContent object containing the content to copy from
	 * @param toContentId 	The new Id of the new behaviourComposer object
	 * @return newContent	The new behaviourComposer content object
	 * @throws RepositoryCheckedException 
	 * @throws ItemNotFoundException 
	 */
	public static BehaviourComposerContent newInstance(BehaviourComposerContent behaviourComposer, Long toContentId, IToolContentHandler toolContentHandler) throws ItemNotFoundException, RepositoryCheckedException
	{
		BehaviourComposerContent newContent = new BehaviourComposerContent(toContentId,
														behaviourComposer.getTitle(),
														behaviourComposer.getContent(),
														behaviourComposer.getOnlineInstructions(),
														behaviourComposer.getOfflineInstructions(),
														behaviourComposer.isDefineLater(),
														behaviourComposer.isForceOffline(),
														behaviourComposer.isContentInUse(),
														behaviourComposer.getCreatorUserId(),
														behaviourComposer.getDateCreated(),
														behaviourComposer.getDateUpdated());
		
		if ( behaviourComposer.getBehaviourComposerAttachments() != null && behaviourComposer.getBehaviourComposerAttachments().size() > 0 ) {
			HashSet newAttachmentSet = new HashSet();
			Iterator iter = behaviourComposer.getBehaviourComposerAttachments().iterator();
			while (iter.hasNext()) {
				BehaviourComposerAttachment element = (BehaviourComposerAttachment) iter.next();
				BehaviourComposerAttachment newAttachment = new BehaviourComposerAttachment(newContent, element.getFilename(), element.isOnlineFile());
				if(toolContentHandler != null){
					//if it is not null, copy file node and refresh uuid and version
					NodeKey keys = toolContentHandler.copyFile(element.getUuid());
					newAttachment.setUuid(keys.getUuid());
					newAttachment.setVersionId(keys.getVersion());
				}else{
					//keep old value
					newAttachment.setUuid(element.getUuid());
					newAttachment.setVersionId(element.getVersionId());
				}
				
				newAttachmentSet.add(newAttachment);
			} 
			newContent.setBehaviourComposerAttachments(newAttachmentSet);
		}
		
		return newContent;
	}
   
	
 
}
