/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestBehaviourComposerContentDAO.java,v 1.7 2006/04/06 07:05:07 fmalikoff Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate;

import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerDataAccessTestCase;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.dao.hibernate.BehaviourComposerContentDAO;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;

/**
 * @author mtruong
 *
 * JUnit Test Cases to test the BehaviourComposerContentDAO class
 */
public class TestBehaviourComposerContentDAO extends BehaviourComposerDataAccessTestCase
{
	private boolean cleanContentData = true;
    
	public TestBehaviourComposerContentDAO(String name)
	{
		super(name);
	}
	
	 /**
     * @see BehaviourComposerDataAccessTestCase#setUp()
     */
	 protected void setUp() throws Exception {
        super.setUp();

        //set up default behaviourComposer content for each test
       	initAllData();
    }
	 
	/**
	 * @see BehaviourComposerDataAccessTestCase#tearDown()
	 */
    protected void tearDown() throws Exception 
    {    	
        //remove behaviourComposer content after each test
       if(cleanContentData)
        {
        	cleanBehaviourComposerContentData(TEST_NB_ID);
        }
    }
   
   public void testfindBehaviourComposerContentByID()
    {
       behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(TEST_NB_ID);
       
        assertContentEqualsTestData(behaviourComposerContent);
    	
    
    	 // Test to see if trying to retrieve a non-existent object would 
    	 // return null or not.
    	 
    	Long nonExistentId = new Long(88777);
    	assertBehaviourComposerContentIsNull(nonExistentId);
       
//	   BehaviourComposerContent behaviourComposer = new BehaviourComposerContent(new Long(3600),	
//				TEST_TITLE,
//				TEST_CONTENT,
//				TEST_ONLINE_INSTRUCTIONS,
//				TEST_OFFLINE_INSTRUCTIONS,
//				TEST_DEFINE_LATER,
//				TEST_CONTENT_IN_USE,
//				TEST_FORCE_OFFLINE,
//				TEST_CREATOR_USER_ID,
//				TEST_DATE_CREATED,
//				TEST_DATE_UPDATED);
//
//	   behaviourComposerDAO.saveBehaviourComposerContent(behaviourComposer);
	   
	 // behaviourComposerDAO.removeBehaviourComposer(new Long(3600));
	//   behaviourComposerDAO.removeBehaviourComposer(behaviourComposerDAO.findBehaviourComposerContentById(new Long(3600)));
	   
	   
    } 
   
   public void testremoveBehaviourComposer()
   {
       cleanContentData = false;     
       
       behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(TEST_NB_ID);
       
       behaviourComposerDAO.removeBehaviourComposer(behaviourComposerContent);
       
       assertBehaviourComposerSessionIsNull(TEST_SESSION_ID); //check if child table is deleted
  	   assertBehaviourComposerContentIsNull(TEST_NB_ID);
   } 
   
   public void testremoveBehaviourComposerById()
   {
       cleanContentData = false;
  	 	
	   
  	 	behaviourComposerDAO.removeBehaviourComposer(TEST_NB_ID);
  	 	
  	 	assertBehaviourComposerSessionIsNull(TEST_SESSION_ID);
  	 	assertBehaviourComposerContentIsNull(TEST_NB_ID);
   }
   
   public void testgetBehaviourComposerContentBySession()
   {
	   	behaviourComposerContent = behaviourComposerDAO.getBehaviourComposerContentBySession(TEST_SESSION_ID);
	   	
	   	assertContentEqualsTestData(behaviourComposerContent);
   }
   

   public void testsaveBehaviourComposerContent()
   {
   	/** 
   	 * an object already created when setUp() is called, so dont need to save another instance 
   	 * TODO: change this, actually test the save method
   	 */
   	
   	behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(getTestBehaviourComposerId());
   	
   	assertContentEqualsTestData(behaviourComposerContent);
   	
   }
   
   public void testupdateBehaviourComposerContent()
   {
   	// Update the behaviourComposer to have a new value for its content field 
   	String newContent = "New updated content";
   	
   	behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(getTestBehaviourComposerId());
   	behaviourComposerContent.setContent(newContent);
   	
   	behaviourComposerDAO.updateBehaviourComposerContent(behaviourComposerContent);
   	
   	//Check whether the value has been updated
   	
   	behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(getTestBehaviourComposerId());
   	
   	assertEquals(behaviourComposerContent.getContent(), newContent);
   	
   } 
      
   public void testremoveBehaviourComposerSessions()
   {
   	
	   	behaviourComposerContent = behaviourComposerDAO.findBehaviourComposerContentById(getTestBehaviourComposerId());
	   	
	   	
	   	behaviourComposerDAO.removeBehaviourComposerSessions(behaviourComposerContent);
	   	behaviourComposerContent.getBehaviourComposerSessions().clear(); //Have to remove/empty the collection before deleting it.
	   	//otherwise exception will occur
	   	behaviourComposerDAO.updateBehaviourComposerContent(behaviourComposerContent);
	   	BehaviourComposerContent behaviourComposer = behaviourComposerDAO.findBehaviourComposerContentById(getTestBehaviourComposerId());
	   	assertNotNull(behaviourComposer);
	   	assertBehaviourComposerSessionIsNull(TEST_SESSION_ID);   	
   }
   
   public void testAddSession()
   {
       Long newSessionId = new Long(87);
       BehaviourComposerSession newSession = new BehaviourComposerSession(newSessionId);
       
       behaviourComposerDAO.addBehaviourComposerSession(TEST_NB_ID, newSession);
       
       BehaviourComposerSession retrievedSession = behaviourComposerSessionDAO.findBehaviourComposerSessionById(newSessionId);
       
       assertEquals(retrievedSession.getBehaviourComposerContent().getBehaviourComposerContentId(), TEST_NB_ID);
       
   }
   
   
 

  
}
