/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerMonitoringAction.java,v 1.22 2006/08/29 03:33:14 mseaton Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.web;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerApplicationException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerConstants;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.service.IBehaviourComposerService;
import org.lamsfoundation.lams.tool.behaviourComposer.service.BehaviourComposerServiceProxy;
import org.lamsfoundation.lams.tool.behaviourComposer.util.BehaviourComposerWebUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

/**
 * @author mtruong
 * 
 * The buttons are a switch between tabs and will forward to a jsp and display
 * the appropriate page.
 * 
 *
 */

/**
 * Creation Date: 14-07-05
 *  
 * ----------------XDoclet Tags--------------------
 * 
 * @struts:action path="/monitoring" name="BehaviourComposerMonitoringForm" scope="request" type="org.lamsfoundation.lams.tool.behaviourComposer.web.BehaviourComposerMonitoringAction"
 *                input=".monitoringContent" validate="false" parameter="method"
 * @struts:action-forward name="monitorPage" path="/monitoring/monitoring.jsp"
 * ----------------XDoclet Tags--------------------
 */
public class BehaviourComposerMonitoringAction extends LamsDispatchAction {
    
    static Logger logger = Logger.getLogger(BehaviourComposerMonitoringAction.class.getName());
    
    public final static String FORM="BehaviourComposerMonitoringForm";
    
    public static final String SUMMARY_TABID = "1";
    public static final String INSTRUCTIONS_TABID = "2";
    public static final String EDITACTIVITY_TABID = "3";
    public static final String STATISTICS_TABID = "4";
   
    public ActionForward unspecified(
    		ActionMapping mapping,
    		ActionForm form,
    		HttpServletRequest request,
    		HttpServletResponse response) throws BehaviourComposerApplicationException
    {
    	Long toolContentId = BehaviourComposerWebUtil.convertToLong(request.getParameter(BehaviourComposerConstants.TOOL_CONTENT_ID));
        String contentFolderID = WebUtil.readStrParam(request, BehaviourComposerConstants.CONTENT_FOLDER_ID);
    	if (toolContentId == null)
 		{
 		    String error = "Unable to continue. Tool content id missing";
 		    logger.error(error);
 			throw new BehaviourComposerApplicationException(error);
 		}
         
        BehaviourComposerMonitoringForm monitorForm = new BehaviourComposerMonitoringForm();

        IBehaviourComposerService behaviourComposerService = BehaviourComposerServiceProxy.getBehaviourComposerService(getServlet().getServletContext());
		BehaviourComposerContent content = behaviourComposerService.retrieveBehaviourComposer(toolContentId);

    	monitorForm.setTitle(content.getTitle());
    	monitorForm.setContent(content.getContent());
    	monitorForm.setOnlineInstructions(content.getOnlineInstructions());
    	monitorForm.setOfflineInstructions(content.getOfflineInstructions());
		monitorForm.setAttachmentsList(BehaviourComposerWebUtil.setupAttachmentList(behaviourComposerService, content));

		if ( BehaviourComposerWebUtil.isContentEditable(content) ) {
			monitorForm.setContentEditable("true");
		    //set up the request parameters to append to the URL
		    Map<String,Object> map = new HashMap<String,Object>();
		    map.put(BehaviourComposerConstants.TOOL_CONTENT_ID, toolContentId.toString());
		    map.put(BehaviourComposerConstants.DEFINE_LATER, "true");
		    map.put(BehaviourComposerConstants.CONTENT_FOLDER_ID, contentFolderID);
		    monitorForm.setParametersToAppend(map);
		} else {
			monitorForm.setContentEditable("false");
		}
		
        //Get the total number of learners that have participated in this tool activity
        monitorForm.setTotalLearners(behaviourComposerService.calculateTotalNumberOfUsers(toolContentId));
        
        Set sessions = content.getBehaviourComposerSessions();
        Iterator i = sessions.iterator();
        Map map = new HashMap();
        while (i.hasNext())
        {
        	BehaviourComposerSession session = (BehaviourComposerSession) i.next();
            int numUsersInSession = behaviourComposerService.getNumberOfUsersInSession(session);
            map.put(session.getBehaviourComposerSessionName(), new Integer(numUsersInSession));
        }
        monitorForm.setGroupStatsMap(map);
        
   		monitorForm.setCurrentTab(SUMMARY_TABID);
        request.setAttribute(FORM, monitorForm);
   		return mapping.findForward(BehaviourComposerConstants.MONITOR_PAGE);
    }
	    
   
   
}
