/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: BehaviourComposerExportAction.java,v 1.10 2006/07/25 04:53:06 steven Exp $$ */
package org.lamsfoundation.lams.tool.behaviourComposer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerApplicationException;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerConstants;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerUser;
import org.lamsfoundation.lams.tool.behaviourComposer.service.IBehaviourComposerService;
import org.lamsfoundation.lams.tool.behaviourComposer.service.BehaviourComposerServiceProxy;
import org.lamsfoundation.lams.tool.behaviourComposer.util.BehaviourComposerWebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;


/**
 * @author mtruong
 *
 * Export Portfolio functionality.
 * 
 * With this behaviourComposer tool,
 * both the learner and teacher will export the contents of the behaviourComposer.
 * 
 */

/**
 * ----------------XDoclet Tags--------------------
 * 
 * @struts:action path="/exportPortfolio" name="BehaviourComposerExportForm" scope="request" type="org.lamsfoundation.lams.tool.behaviourComposer.web.BehaviourComposerExportAction"
 *                validate="false" parameter="mode"
 * @struts:action-forward name="exportPortfolio" path="/exportPortfolio.jsp"
 * ----------------XDoclet Tags--------------------
 */
public class BehaviourComposerExportAction extends LamsDispatchAction {
    
    static Logger logger = Logger.getLogger(BehaviourComposerExportForm.class.getName());

    public ActionForward unspecified(
    		ActionMapping mapping,
    		ActionForm form,
    		HttpServletRequest request,
    		HttpServletResponse response)
    {
        return mapping.findForward(BehaviourComposerConstants.EXPORT_PORTFOLIO);
    }
    
    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
    {
       //parameters given are the toolSessionId and userId
        BehaviourComposerExportForm exportForm = (BehaviourComposerExportForm)form;
        Long toolSessionId = BehaviourComposerWebUtil.convertToLong(request.getParameter(BehaviourComposerConstants.TOOL_SESSION_ID));
        Long userId = BehaviourComposerWebUtil.convertToLong(request.getParameter(BehaviourComposerConstants.USER_ID));
      
        
        IBehaviourComposerService behaviourComposerService = BehaviourComposerServiceProxy.getBehaviourComposerService(getServlet().getServletContext());
        
        if (userId == null || toolSessionId == null)
        {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error(error);
            throw new BehaviourComposerApplicationException(error);
        }
        
        BehaviourComposerUser userInThisSession = behaviourComposerService.retrieveBehaviourComposerUserBySession(userId, toolSessionId);
        
        if (userInThisSession == null)
        {
            String error="The user with user id " + userId + " does not exist in this session or session may not exist.";
            logger.error(error);
            throw new BehaviourComposerApplicationException(error);
        }
        
       BehaviourComposerContent content = behaviourComposerService.retrieveBehaviourComposerBySessionID(toolSessionId);
        
        if (content == null)
        {
            String error="The content for this activity has not been defined yet.";
            logger.error(error);
            throw new BehaviourComposerApplicationException(error);
        }
               
        exportForm.populateForm(content);
       
        return mapping.findForward(BehaviourComposerConstants.EXPORT_PORTFOLIO);
    }
    
    public ActionForward teacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
    {
        //given the toolcontentId as a parameter
        BehaviourComposerExportForm exportForm = (BehaviourComposerExportForm)form;
        IBehaviourComposerService behaviourComposerService = BehaviourComposerServiceProxy.getBehaviourComposerService(getServlet().getServletContext());
        
        Long toolContentId = BehaviourComposerWebUtil.convertToLong(request.getParameter(BehaviourComposerConstants.TOOL_CONTENT_ID));
       
        //check if toolContentId exists in db or not
        if (toolContentId==null)
        {
            String error="Tool Content Id is missing. Unable to continue";
            logger.error(error);
            throw new BehaviourComposerApplicationException(error);
        }
        
        BehaviourComposerContent content = behaviourComposerService.retrieveBehaviourComposer(toolContentId);
        
        if (content == null)
        {
            String error="Data is missing from the database. Unable to Continue";
            logger.error(error);
            throw new BehaviourComposerApplicationException(error);
        }
        
        exportForm.populateForm(content);
  
   		return mapping.findForward(BehaviourComposerConstants.EXPORT_PORTFOLIO);
    }
    
    
}
