/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: TestModel.java,v 1.7 2006/04/07 00:47:24 fmalikoff Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.dao;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import junit.framework.TestCase;

import org.lamsfoundation.lams.tool.behaviourComposer.BCSubmissionDetails;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerReport;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;

/**
 * @author Steve.Ni
 */
public class TestModel extends TestCase {
	//report data
	private static String commA ="commA";
	private static Long markA = new Long(100);
	private static Long repA = new Long(100);
	private static int dayA = 10;
	private static int mthA = 9;
	private static int yearA = 2003;
	
	private static String commB ="commB";
	private static Long markB = new Long(201);
	private static Long repB = new Long(201);
	private static int dayB = 11;
	private static int mthB = 8;
	private static int yearB = 2004;

	//content data
	private static String insA = "InstructionsA";
	private static String insB = "InstructionsB";
	private static String titA = "titleA";
	private static String titB = "titleB";
	private static boolean deA = false;
	private static boolean deB = true;
	private static boolean offA = false;
	private static boolean offB = false;
	//session data
	private static Long sessA = new Long(100);
	private static Integer statA = new Integer(100);
	private static Long sessB = new Long(200);
	private static Integer statB = new Integer(200);
	//detail data
	private String filePathA = "fpA";
	private String filePathB = "fpB";
	
	private BehaviourComposerContent content;
	private BehaviourComposerReport report;
	private BehaviourComposerSession session;
	private BCSubmissionDetails detail;
	
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		content = new BehaviourComposerContent();
		
		content.setContentID(new Long(1));
		session = new BehaviourComposerSession();
		detail = new BCSubmissionDetails();
		report = new BehaviourComposerReport();
	}
	/*
	 * Class under test for BehaviourComposerReport clone()
	 */
	public void testReportClone(){
		fillReportA(report);
		BehaviourComposerReport reportC = (BehaviourComposerReport) report.clone();
		fillReportB(report);
		
		assertEquals(reportC.getComments(),commA);
		Calendar cal = Calendar.getInstance();
		cal.set(yearA,mthA,dayA);
		assertEquals(reportC.getDateMarksReleased(),cal.getTime());
		assertEquals(reportC.getMarks(),markA);
		assertEquals(reportC.getReportID(),repA);
				
	}
	/*
	 * Class under test for BehaviourComposerSession clone()
	 */
	public void testSessionClone() {
		fillSessionA(session);
		BehaviourComposerSession sessionC = (BehaviourComposerSession) session.clone();
		fillSessionB(session);
		
		assertEquals(sessionC.getSessionID(),sessA);
		assertEquals(sessionC.getStatus(),statA);
		//test SubmissionDetails Set 
		Iterator iter = sessionC.getBcSubmissionDetails().iterator();
		BCSubmissionDetails detail = new BCSubmissionDetails();
		fillDetailA(detail);
		assertEquals(iter.next(),detail);
		//test SubmissionDetails Set 
		iter = session.getBcSubmissionDetails().iterator();
		detail = new BCSubmissionDetails();
		fillDetailB(detail);
		assertEquals(iter.next(),detail);

	}	
	/*
	 * Class under test for BehaviourComposerSession clone()
	 */
	public void testDetailClone() {
		fillDetailA(detail);
		BCSubmissionDetails detailC = (BCSubmissionDetails) detail.clone();
		fillDetailB(detail);
		
		assertEquals(detailC.getFilePath(),filePathA);
		BehaviourComposerReport report = new BehaviourComposerReport(); 
		fillReportA(report);
		assertEquals(detailC.getReport(),report);
		
	}	

	
	/*
	 * Class under test for BehaviourComposerContent clone()
	 */
	public void testContentClone() {
		fillContentA(content);
		BehaviourComposerContent contentC = (BehaviourComposerContent) content.clone();
		fillContentB(content);
		
		assertEquals(contentC.getInstruction(),insA);
		assertEquals(contentC.getTitle(),titA);
		assertEquals(contentC.isDefineLater(),deA);
		assertEquals(contentC.isRunOffline(),offA);
		//test BehaviourComposerSession l Set 
		Iterator iter = contentC.getToolSession().iterator();
		BehaviourComposerSession session = new BehaviourComposerSession();
		fillSessionA(session);
		assertEquals(iter.next(),session);
		
		//do more test to ensure origial object keep desired values "B"
		assertEquals(content.getInstruction(),insB);
		assertEquals(content.getTitle(),titB);
		assertEquals(content.isDefineLater(),deB);
		assertEquals(content.isRunOffline(),offB);
		//test BehaviourComposerSession l Set 
		iter = content.getToolSession().iterator();
		session = new BehaviourComposerSession();
		fillSessionB(session);
		assertEquals(iter.next(),session);
		
	}
	//================Fill init data for model object==========
	private void fillReportA(BehaviourComposerReport report){
		report.setComments(commA);
		Calendar cal = Calendar.getInstance();
		cal.set(yearA,mthA,dayA);
		report.setDateMarksReleased(cal.getTime());
		report.setMarks(markA);
		report.setReportID(repA);
	}
	private void fillReportB(BehaviourComposerReport report){
		report.setComments(commB);
		Calendar cal = Calendar.getInstance();
		cal.set(yearB,mthB,dayB);
		report.setDateMarksReleased(cal.getTime());
		report.setMarks(markB);
		report.setReportID(repB);
	}
	private void fillContentA(BehaviourComposerContent content){
		content.setDefineLater(deA);
		content.setInstruction(insA);
		content.setRunOffline(offA);
		content.setTitle(titA);
		//fill sessions
		BehaviourComposerSession session = new BehaviourComposerSession();
		fillSessionA(session);
		Set sessions = new HashSet();
		sessions.add(session);
		content.setToolSession(sessions);
	}
	private void fillContentB(BehaviourComposerContent content){
		content.setDefineLater(deB);
		content.setInstruction(insB);
		content.setRunOffline(offB);
		content.setTitle(titB);

		//fill sessions
		BehaviourComposerSession session = new BehaviourComposerSession();
		fillSessionB(session);
		Set sessions = new HashSet();
		sessions.add(session);
		content.setToolSession(sessions);
	}
	private void fillSessionA(BehaviourComposerSession session){
		session.setSessionID(sessA);
		session.setStatus(statA);
		//fill details
		BCSubmissionDetails detail = new BCSubmissionDetails();
		fillDetailA(detail);
		Set details = new HashSet();
		details.add(detail);
		session.setBcSubmissionDetails(details);

	}
	private void fillSessionB(BehaviourComposerSession session){
		session.setSessionID(sessB);
		session.setStatus(statB);
		//fill details
		BCSubmissionDetails detail = new BCSubmissionDetails();
		fillDetailB(detail);
		Set details = new HashSet();
		details.add(detail);
		session.setBcSubmissionDetails(details);
	}
	
	/**
	 * @param detail2
	 */
	private void fillDetailA(BCSubmissionDetails detail) {
		detail.setFilePath(filePathA);
		BehaviourComposerReport report = new BehaviourComposerReport(); 
		fillReportA(report);
		detail.setReport(report);
	}
	/**
	 * @param detail2
	 */
	private void fillDetailB(BCSubmissionDetails detail) {
		detail.setFilePath(filePathB);
		BehaviourComposerReport report = new BehaviourComposerReport(); 
		fillReportB(report);
		detail.setReport(report);
	}
}
