/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: MonitoringAction.java,v 1.33 2006/08/23 05:42:37 steven Exp $$ */	

package org.lamsfoundation.lams.tool.behaviourComposer.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerContent;
import org.lamsfoundation.lams.tool.behaviourComposer.BehaviourComposerSession;
import org.lamsfoundation.lams.tool.behaviourComposer.dto.AuthoringDTO;
import org.lamsfoundation.lams.tool.behaviourComposer.dto.FileDetailsDTO;
import org.lamsfoundation.lams.tool.behaviourComposer.dto.SessionDTO;
import org.lamsfoundation.lams.tool.behaviourComposer.dto.StatisticDTO;
import org.lamsfoundation.lams.tool.behaviourComposer.service.IBehaviourComposerService;
import org.lamsfoundation.lams.tool.behaviourComposer.service.BehaviourComposerServiceProxy;
import org.lamsfoundation.lams.tool.behaviourComposer.util.BehaviourComposerConstants;
import org.lamsfoundation.lams.tool.behaviourComposer.util.BehaviourComposerWebUtils;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.util.AttributeNames;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * @author Manpreet Minhas
 * @struts.action
 * 				path="/monitoring"
 * 				parameter="method"
 * 				scope="request"
 * 				validate="false"
 * 				name="BehaviourComposerMonitoringForm" 				
 * 
 * @struts.action-forward name="listMark" path="/monitoring/mark/mark.jsp"
 * @struts.action-forward name="updateMark" path="/monitoring/mark/updatemark.jsp"
 * @struts.action-forward name="listAllMarks" path="/monitoring/mark/allmarks.jsp"
 * 
 * @struts.action-forward name="success" path="/monitoring/monitoring.jsp"
 * 
 * @struts.action-forward name="statistic" path="/monitoring/parts/statisticpart.jsp"
 * 
 */
public class MonitoringAction extends LamsDispatchAction {
	
	public IBehaviourComposerService behaviourComposerService;
	
    
	private class SessionComparator implements Comparator<SessionDTO>{
		public int compare(SessionDTO o1, SessionDTO o2) {
			if(o1 != null && o2 != null){
				return o1.getSessionName().compareTo(o2.getSessionName());
			}else if(o1 != null)
				return 1;
			else
				return -1;
		}
	}
    /**
     * Default ActionForward for Monitor
     */
    public ActionForward unspecified(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
    	Long contentID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_CONTENT_ID));
    	behaviourComposerService = getBehaviourComposerService();
    	
//    	List userList = behaviourComposerService.getUsers(sessionID);
        List behaviourComposerSessionList = behaviourComposerService.getBehaviourComposerSessionByContentID(contentID);
        summary(request, behaviourComposerSessionList);
		statistic(request, behaviourComposerSessionList);
		
		//instruction
		BehaviourComposerContent persistContent = behaviourComposerService.getBehaviourComposerContent(contentID);
		//if this content does not exist, then reset the contentID to current value to keep it on HTML page.
		persistContent.setContentID(contentID); 
		
		AuthoringDTO authorDto = new AuthoringDTO(persistContent);
		request.setAttribute(BehaviourComposerConstants.AUTHORING_DTO,authorDto);
		request.setAttribute(BehaviourComposerConstants.PAGE_EDITABLE, new Boolean(BehaviourComposerWebUtils.isBehaviourComposerEditable(persistContent)));
		
		return mapping.findForward("success");
    }
    /**
     * AJAX call to refresh statisitic page.
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     */
    public ActionForward doStatistic(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
    	Long contentID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_CONTENT_ID));
    	behaviourComposerService = getBehaviourComposerService();
    	
//    	List userList = behaviourComposerService.getUsers(sessionID);
        List behaviourComposerSessionList = behaviourComposerService.getBehaviourComposerSessionByContentID(contentID);
		statistic(request, behaviourComposerSessionList);
		
		return mapping.findForward("statistic");
		
    }
	/**
	 * Release mark
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 */
	public ActionForward releaseMarks(ActionMapping mapping,
			   ActionForm form,
			   HttpServletRequest request,
			   HttpServletResponse response){

		//get service then update report table
		behaviourComposerService = getBehaviourComposerService();
		Long sessionID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_SESSION_ID));
		behaviourComposerService.releaseMarksForSession(sessionID);
		try {
			PrintWriter out = response.getWriter();
			BehaviourComposerSession session = behaviourComposerService.getSessionById(sessionID);
			String sessionName = "";
			if(session != null)
				sessionName = session.getSessionName();
			out.write(getMessageService().getMessage("msg.mark.released",new String[]{sessionName}));
			out.flush();
		} catch (IOException e) {
		}
		
		return null;
	}
	/**
	 * Download behaviourComposer file marks by MS Excel file format.
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 */
	public ActionForward downloadMarks(ActionMapping mapping,
			   ActionForm form,
			   HttpServletRequest request,
			   HttpServletResponse response){
		
		Long sessionID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_SESSION_ID));
		behaviourComposerService = getBehaviourComposerService();
		//return FileDetailsDTO list according to the given sessionID
		Map userFilesMap = behaviourComposerService.getFilesUploadedBySession(sessionID);
		//construct Excel file format and download
		String errors = null;
		try {
			//create an empty excel file
			HSSFWorkbook wb = new HSSFWorkbook();
			HSSFSheet sheet = wb.createSheet("Marks");
			sheet.setColumnWidth((short)0,(short)5000);
			HSSFRow row,row1=null,row2=null,row3=null,row4=null;
			HSSFCell cell;
			Iterator iter = userFilesMap.values().iterator();
			Iterator dtoIter; 
			boolean first = true;
			int idx = 0;
			int fileCount = 0;
			while(iter.hasNext()){
				List list = (List) iter.next();
				dtoIter = list.iterator();
				first = true;
				
				while(dtoIter.hasNext()){
					FileDetailsDTO dto = (FileDetailsDTO) dtoIter.next();
					if(first){
						row = sheet.createRow(idx++);
						cell = row.createCell((short) 0);
						cell.setCellValue(dto.getUserDTO().getFirstName()+" "+dto.getUserDTO().getLastName());
						sheet.addMergedRegion(new Region(idx-1,(short)0,idx-1, (short)1));
						first = false;
						row1 = sheet.createRow(idx+1);
						cell = row1.createCell((short) 0);
						cell.setCellValue("File name");
						row2 = sheet.createRow(idx+2);
						cell = row2.createCell((short) 0);
						cell.setCellValue("File description");
						row3 = sheet.createRow(idx+3);
						cell = row3.createCell((short) 0);
						cell.setCellValue("Marks");
						row4 = sheet.createRow(idx+4);
						cell = row4.createCell((short) 0);
						cell.setCellValue("Comments");
						idx += 6;
						fileCount = 0;
					}
					++fileCount;
					sheet.setColumnWidth((short)fileCount,(short)8000);
					cell = row1.createCell((short) fileCount);
					cell.setCellValue(dto.getFilePath());
					
					cell = row2.createCell((short) fileCount);
					cell.setCellValue(dto.getFileDescription());
					
					cell = row3.createCell((short) fileCount);
					if(dto.getMarks() != null)
						cell.setCellValue(new Double(dto.getMarks().toString()).doubleValue());
					else
						cell.setCellValue("");
					
					cell = row4.createCell((short) fileCount);
					cell.setCellValue(dto.getComments());
				}
			}
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			wb.write(bos);
			//construct download file response header
			String fileName = "marks" + sessionID+".xls";
			String mineType = "application/vnd.ms-excel";
			String header = "attachment; filename=\"" + fileName + "\";";
			response.setContentType(mineType);
			response.setHeader("Content-Disposition",header);

			byte[] data = bos.toByteArray();
			response.getOutputStream().write(data,0,data.length);
			response.getOutputStream().flush();
		} catch (Exception e) {
			log.error(e);
			errors =new ActionMessage("monitoring.download.error",e.toString()).toString();
		}

		if(errors != null){
			try {
				PrintWriter out = response.getWriter();
				out.write(errors);
				out.flush();
			} catch (IOException e) {
			}
		}
			
		return null;
	}
	//**********************************************************
	// Mark udpate/view methods
	//**********************************************************
	/**
	 * Display special user's marks information. 
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 */
	public ActionForward listMark(ActionMapping mapping,
							   ActionForm form,
							   HttpServletRequest request,
							   HttpServletResponse response){
		Long sessionID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_SESSION_ID));
		Long userID = new Long(WebUtil.readLongParam(request,"userID"));

		behaviourComposerService = getBehaviourComposerService();
		//return FileDetailsDTO list according to the given userID and sessionID
		List files = behaviourComposerService.getFilesUploadedByUser(userID,sessionID);
		
		request.setAttribute(AttributeNames.PARAM_TOOL_SESSION_ID,sessionID);
		request.setAttribute("report",files);
		return mapping.findForward("listMark");
	}
	/**
	 * Display update mark initial page.
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 */
	public ActionForward newMark(ActionMapping mapping,
			  ActionForm form,
			  HttpServletRequest request,
			  HttpServletResponse response){
		
		Long sessionID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_SESSION_ID));
		Long userID = new Long(WebUtil.readLongParam(request,"userID"));
		Long detailID = new Long(WebUtil.readLongParam(request,"detailID"));
		String updateMode = request.getParameter("updateMode");
		
		behaviourComposerService = getBehaviourComposerService();
		
		List report = new ArrayList<FileDetailsDTO>();
		report.add(behaviourComposerService.getFileDetails(detailID));
		
		request.setAttribute("report",report);
		request.setAttribute("updateMode", updateMode);
		request.setAttribute(AttributeNames.PARAM_TOOL_SESSION_ID,sessionID);
		
		return mapping.findForward("updateMark");
	}



	/**
	 * Update mark.
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 */
	public ActionForward updateMark(ActionMapping mapping,
							   ActionForm form,
							   HttpServletRequest request,
							   HttpServletResponse response){
		Long sessionID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_SESSION_ID));
		Long userID = new Long(WebUtil.readLongParam(request,"userID"));
		Long detailID = new Long(WebUtil.readLongParam(request,"detailID"));
		String updateMode = request.getParameter("updateMode");
		Long reportID= new Long(WebUtil.readLongParam(request,"reportID"));
		
		ActionMessages errors = new ActionMessages();  
		//check whether the mark is validate
		String markStr = request.getParameter("marks");
		Long marks = null;
		try {
			marks = Long.parseLong(markStr);
		} catch (Exception e) {
			errors.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("errors.mark.invalid.number"));
		}
		
		String comments = WebUtil.readStrParam(request,"comments",true);
		if(!errors.isEmpty()){
			behaviourComposerService = getBehaviourComposerService();
			List report = new ArrayList<FileDetailsDTO>();
			FileDetailsDTO fileDetail = behaviourComposerService.getFileDetails(detailID);
			//echo back the input, even they are wrong.
			fileDetail.setComments(comments);
			fileDetail.setMarks(markStr);
			report.add(fileDetail);
			
			request.setAttribute("report",report);
			request.setAttribute("updateMode", updateMode);
			request.setAttribute(AttributeNames.PARAM_TOOL_SESSION_ID,sessionID);
			
			
			saveErrors(request,errors);
			return mapping.findForward("updateMark");
		}
		
		//get service then update report table
		behaviourComposerService = getBehaviourComposerService();
		
		behaviourComposerService.updateMarks(reportID,marks,comments);
		
		if(StringUtils.equals(updateMode, "listMark")){
			List report = behaviourComposerService.getFilesUploadedByUser(userID,sessionID);
			request.setAttribute("report",report);
			request.setAttribute(AttributeNames.PARAM_TOOL_SESSION_ID,sessionID);
			return mapping.findForward("listMark");
		}else{
			Map report = behaviourComposerService.getFilesUploadedBySession(sessionID);
			request.setAttribute("reports",report);
			return mapping.findForward("listAllMarks");
		}
	}
	/**
	 * View mark of all learner from same tool content ID. 
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 */
	public ActionForward listAllMarks(ActionMapping mapping,
			   ActionForm form,
			   HttpServletRequest request,
			   HttpServletResponse response){
		
		Long sessionID =new Long(WebUtil.readLongParam(request,AttributeNames.PARAM_TOOL_SESSION_ID));
		behaviourComposerService = getBehaviourComposerService();
		//return FileDetailsDTO list according to the given sessionID
		Map userFilesMap = behaviourComposerService.getFilesUploadedBySession(sessionID);
		request.setAttribute(AttributeNames.PARAM_TOOL_SESSION_ID,sessionID);
//		request.setAttribute("user",behaviourComposerService.getUserDetails(userID));
		request.setAttribute("reports",userFilesMap);
		
		return mapping.findForward("listAllMarks");

	}	
	//**********************************************************
	// Private methods
	//**********************************************************
	
	private IBehaviourComposerService getBehaviourComposerService(){
		return BehaviourComposerServiceProxy
			   .getBehaviourComposerService(this.getServlet()
			   .getServletContext());
	}
	
	/**
	 * Return ResourceService bean.
	 */
	private MessageService getMessageService() {
	      WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(getServlet().getServletContext());
	      return (MessageService) wac.getBean("behaviourComposerMessageService");
	}
	/**
	 * Save file mark information into HttpRequest
	 * @param request
	 * @param sessionID
	 * @param userID
	 * @param detailID
	 * @param updateMode
	 */
	private void setMarkPage(HttpServletRequest request, Long sessionID, Long userID, Long detailID, String updateMode) {

	}
	/**
	 * Save statistic information into request
	 * @param request
	 * @param behaviourComposerSessionList
	 */
	private void statistic(HttpServletRequest request, List behaviourComposerSessionList) {
		Iterator it;
		Map<SessionDTO, StatisticDTO> sessionStatisticMap = new TreeMap<SessionDTO, StatisticDTO>(this.new SessionComparator());

		// build a map with all users in the behaviourComposerSessionList
		it = behaviourComposerSessionList.iterator();
		while (it.hasNext()) {
			
			BehaviourComposerSession sfs = (BehaviourComposerSession) it.next();
			Long sessionID = sfs.getSessionID();
			String sessionName = sfs.getSessionName();
				
			//return FileDetailsDTO list according to the given sessionID
			Map userFilesMap = behaviourComposerService.getFilesUploadedBySession(sessionID);
			Iterator iter = userFilesMap.values().iterator();
			Iterator dtoIter; 
			int notMarkedCount = 0;
			int markedCount = 0;
			while(iter.hasNext()){
				List list = (List) iter.next();
				dtoIter = list.iterator();
				while(dtoIter.hasNext()){
					FileDetailsDTO dto = (FileDetailsDTO) dtoIter.next();
					if(dto.getMarks() == null)
						notMarkedCount++;
					else
						markedCount++;
				}
			}
			StatisticDTO statisticDto = new StatisticDTO();
			SessionDTO sessionDto = new SessionDTO();
			statisticDto.setMarkedCount(markedCount);
			statisticDto.setNotMarkedCount(notMarkedCount);
			statisticDto.setTotalUploadedFiles(markedCount+notMarkedCount);
			sessionDto.setSessionID(sessionID);
			sessionDto.setSessionName(sessionName);
			sessionStatisticMap.put(sessionDto,statisticDto);
		}

		request.setAttribute("statisticList",sessionStatisticMap);
	}
	/**
	 * Save Summary information into HttpRequest.
	 * @param request
	 * @param behaviourComposerSessionList
	 */
	private void summary(HttpServletRequest request, List behaviourComposerSessionList) {
		Map<SessionDTO, List> sessionUserMap = new TreeMap<SessionDTO, List>(this.new SessionComparator());
        
        //build a map with all users in the behaviourComposerSessionList
        Iterator it = behaviourComposerSessionList.iterator();
        while(it.hasNext()){
        	SessionDTO sessionDto = new SessionDTO();
        	BehaviourComposerSession sfs = (BehaviourComposerSession)it.next();
        	
            Long sessionID = sfs.getSessionID();
            sessionDto.setSessionID(sessionID);
            sessionDto.setSessionName(sfs.getSessionName());
            List userList = behaviourComposerService.getUsers(sessionID);
            sessionUserMap.put(sessionDto, userList);
        }
        
		//request.setAttribute(AttributeNames.PARAM_TOOL_SESSION_ID,sessionID);
		request.setAttribute("sessionUserMap",sessionUserMap);
	}

}
